/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexDegreeEquivalenceComparator<V, E>
implements EquivalenceComparator<V, Graph<V, E>> {
    @Override
    public boolean equivalenceCompare(V v, V v2, Graph<V, E> graph, Graph<V, E> graph2) {
        InOutDegrees inOutDegrees = this.getInOutDegrees(graph, v);
        InOutDegrees inOutDegrees2 = this.getInOutDegrees(graph2, v2);
        boolean bl = inOutDegrees.equals(inOutDegrees2);
        return bl;
    }

    @Override
    public int equivalenceHashcode(V v, Graph<V, E> graph) {
        InOutDegrees inOutDegrees = this.getInOutDegrees(graph, v);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(inOutDegrees.inDegree));
        stringBuffer.append("-");
        stringBuffer.append(String.valueOf(inOutDegrees.outDegree));
        return stringBuffer.toString().hashCode();
    }

    protected InOutDegrees getInOutDegrees(Graph<V, E> graph, V v) {
        int n = 0;
        int n2 = 0;
        if (graph instanceof UndirectedGraph) {
            UndirectedGraph undirectedGraph = (UndirectedGraph)graph;
            n2 = n = undirectedGraph.degreeOf(v);
        } else if (graph instanceof DirectedGraph) {
            DirectedGraph directedGraph = (DirectedGraph)graph;
            n = directedGraph.inDegreeOf(v);
            n2 = directedGraph.outDegreeOf(v);
        } else {
            throw new RuntimeException("contextGraph is of unsupported type . It must be one of these two : UndirectedGraph or DirectedGraph");
        }
        return new InOutDegrees(n, n2);
    }

    protected class InOutDegrees {
        public int inDegree;
        public int outDegree;

        public InOutDegrees(int n, int n2) {
            this.inDegree = n;
            this.outDegree = n2;
        }

        public boolean equals(Object object) {
            InOutDegrees inOutDegrees = (InOutDegrees)object;
            return this.inDegree == inOutDegrees.inDegree && this.outDegree == inOutDegrees.outDegree;
        }
    }
}

