/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jopendocument.dom.OOUtils;

public enum ODValueType {
    FLOAT("value", new Class[]{Number.class}){

        @Override
        public String format(Object object) {
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).toPlainString();
            }
            return ((Number)object).toString();
        }

        @Override
        public BigDecimal parse(String string) {
            return new BigDecimal(string);
        }
    }
    ,
    PERCENTAGE("value", new Class[]{Number.class}){

        @Override
        public String format(Object object) {
            return FLOAT.format(object);
        }

        @Override
        public Object parse(String string) {
            return FLOAT.parse(string);
        }
    }
    ,
    CURRENCY("value", new Class[]{Number.class}){

        @Override
        public String format(Object object) {
            return FLOAT.format(object);
        }

        @Override
        public Object parse(String string) {
            return FLOAT.parse(string);
        }
    }
    ,
    DATE("date-value", new Class[]{Date.class, Calendar.class}){

        @Override
        public String format(Object object) {
            Date date = object instanceof Calendar ? ((Calendar)object).getTime() : (Date)object;
            return OOUtils.DATE_FORMAT.format(date);
        }

        @Override
        public Date parse(String string) {
            if (string.length() == 0) {
                return null;
            }
            try {
                return (Date)OOUtils.DATE_FORMAT.parseObject(string);
            }
            catch (ParseException parseException) {
                throw new IllegalStateException("wrong date: " + string, parseException);
            }
        }
    }
    ,
    TIME("time-value", new Class[]{Calendar.class}){

        @Override
        public String format(Object object) {
            Calendar calendar = (Calendar)object;
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)OOUtils.TIME_FORMAT.clone();
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            return simpleDateFormat.format(calendar.getTime());
        }

        @Override
        public Calendar parse(String string) {
            if (string.length() == 0) {
                return null;
            }
            Calendar calendar = (Calendar)OOUtils.TIME_FORMAT.getCalendar().clone();
            try {
                calendar.setTime((Date)OOUtils.TIME_FORMAT.parseObject(string));
            }
            catch (ParseException parseException) {
                throw new IllegalStateException("wrong date: " + string, parseException);
            }
            return calendar;
        }
    }
    ,
    BOOLEAN("boolean-value", new Class[]{Boolean.class}){

        @Override
        public String format(Object object) {
            return ((Boolean)object).toString().toLowerCase();
        }

        @Override
        public Boolean parse(String string) {
            return Boolean.valueOf(string);
        }
    }
    ,
    STRING("string-value", new Class[]{String.class}){

        @Override
        public String format(Object object) {
            return object.toString();
        }

        @Override
        public String parse(String string) {
            return string;
        }
    };

    private final String attr;
    private final List<Class<?>> acceptedClasses;

    private ODValueType(String string2, Class<?> ... classArray) {
        this.attr = string2;
        this.acceptedClasses = Arrays.asList(classArray);
    }

    public final String getValueAttribute() {
        return this.attr;
    }

    public boolean canFormat(Class<?> clazz) {
        for (Class<?> clazz2 : this.acceptedClasses) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public abstract String format(Object var1);

    public abstract Object parse(String var1);

    public final String getName() {
        return this.name().toLowerCase();
    }

    public static ODValueType get(String string) {
        return ODValueType.valueOf(string.toUpperCase());
    }

    public static ODValueType forObject(Object object) {
        if (object instanceof Number) {
            return FLOAT;
        }
        if (object instanceof Boolean) {
            return BOOLEAN;
        }
        if (object instanceof String) {
            return STRING;
        }
        if (object instanceof Calendar && !((Calendar)object).isSet(5)) {
            return TIME;
        }
        if (DATE.canFormat(object.getClass())) {
            return DATE;
        }
        return null;
    }
}

