/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.NationalHandlers;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlHandler;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.XmlUtils;

public class GmlReader
extends GeographicReader {
    public static final String GML_FEATURE_MEMBER = "featureMember";
    public static final String GML_LINE_STRING = "LineString";
    public static final String GML_LINEAR_RING = "LinearRing";
    public static final String GML_POINT = "Point";
    public static final String GML_SURFACE = "Surface";
    public static final String GML_SRS_NAME = "srsName";
    public static final String GML_SRS_DIMENSION = "srsDimension";
    public static final String GML_POS_LIST = "posList";
    public static final String GML_COORDINATES = "coordinates";
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final GmlHandler gmlHandler;
    private final XMLStreamReader parser;
    private int dim;
    private final Map<String, CrsData> crsDataMap = new HashMap<String, CrsData>();

    public GmlReader(XMLStreamReader parser, GmlHandler handler) {
        super(handler, NationalHandlers.DEFAULT_GML_HANDLERS);
        this.parser = parser;
        this.gmlHandler = handler;
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException, XMLStreamException {
        UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in, (String)OdConstants.UTF8);
        XMLStreamReader parser = XmlUtils.newSafeXMLInputFactory().createXMLStreamReader((Reader)ir);
        try {
            return new GmlReader(parser, handler != null ? handler.getGmlHandler() : null).parseDoc(instance);
        }
        catch (XMLStreamException | FactoryException | TransformException | GeoCrsException | GeoMathTransformException e) {
            throw new IOException(e);
        }
    }

    private boolean isElement(String element) {
        return this.parser.getLocalName().matches("(gml:)?" + element);
    }

    private DataSet parseDoc(ProgressMonitor instance) throws XMLStreamException, GeoCrsException, FactoryException, GeoMathTransformException, MismatchedDimensionException, TransformException {
        Object parent;
        Object object = parent = instance != null ? instance.getWindowParent() : MainApplication.getMainFrame();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.isElement(GML_FEATURE_MEMBER)) continue;
            try {
                this.parseFeatureMember((Component)parent);
            }
            catch (UserCancelException e) {
                Logging.trace((Throwable)e);
                return this.ds;
            }
        }
        return this.ds;
    }

    private void findCRS(String srs) throws FactoryException {
        Logging.info((String)("Finding CRS for " + srs));
        if (this.gmlHandler != null) {
            this.crs = this.gmlHandler.getCrsFor(srs);
        } else {
            for (GmlHandler h : NationalHandlers.DEFAULT_GML_HANDLERS) {
                this.crs = h.getCrsFor(srs);
                if (this.crs == null) continue;
                return;
            }
        }
    }

    private void parseSrs(Component parent) throws GeoCrsException, FactoryException, UserCancelException, GeoMathTransformException {
        String srs = this.parser.getAttributeValue(null, GML_SRS_NAME);
        String sdim = this.parser.getAttributeValue(null, GML_SRS_DIMENSION);
        this.dim = sdim != null ? Integer.parseInt(sdim) : 2;
        CrsData crsData = this.crsDataMap.get(srs);
        if (crsData == null) {
            try {
                this.findCRS(srs);
            }
            catch (FactoryException e) {
                Logging.error((Throwable)e);
            }
            if (this.crs == null) {
                throw new GeoCrsException("Unable to detect CRS for srs '" + srs + "' !");
            }
            this.findMathTransform(parent, false);
            this.crsDataMap.put(srs, new CrsData(this.crs, this.transform, this.dim));
        } else {
            this.crs = crsData.crs;
            this.transform = crsData.transform;
            this.dim = crsData.dim;
        }
    }

    private void parseFeatureMember(Component parent) throws XMLStreamException, GeoCrsException, FactoryException, UserCancelException, GeoMathTransformException, MismatchedDimensionException, TransformException {
        Way way = null;
        HashMap<String, StringBuilder> tags = new HashMap<String, StringBuilder>();
        Way prim = null;
        String key = null;
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                Node node;
                String[] tab;
                if (this.isElement(GML_LINE_STRING)) {
                    prim = way = this.createWay();
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_LINEAR_RING)) {
                    prim = way = this.createWay();
                    continue;
                }
                if (this.isElement(GML_POINT)) {
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_SURFACE)) {
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_POS_LIST)) {
                    tab = this.parser.getElementText().split(" ");
                    for (int i = 0; i < tab.length; i += this.dim) {
                        Point p = this.geometryFactory.createPoint(new Coordinate(Double.parseDouble(tab[i]), Double.parseDouble(tab[i + 1])));
                        node = this.createOrGetNode(p, this.dim > 2 && !"0".equals(tab[i + 2]) ? tab[i + 2] : null);
                        if (way != null) {
                            way.addNode(node);
                            continue;
                        }
                        prim = node;
                    }
                    continue;
                }
                if (this.isElement(GML_COORDINATES)) {
                    tab = this.parser.getElementText().trim().split(",");
                    Point p = this.geometryFactory.createPoint(new Coordinate(Double.parseDouble(tab[0]), Double.parseDouble(tab[1])));
                    node = this.createOrGetNode(p);
                    if (way != null) continue;
                    prim = node;
                    continue;
                }
                key = this.parser.getLocalName();
                if (!key.startsWith("ogr:")) continue;
                key = key.substring("ogr:".length());
                continue;
            }
            if (event == 2) {
                if (!this.isElement(GML_FEATURE_MEMBER)) continue;
                break;
            }
            if (event != 4 || key == null) continue;
            StringBuilder sb = tags.computeIfAbsent(key, k -> new StringBuilder());
            sb.append(this.parser.getTextCharacters(), this.parser.getTextStart(), this.parser.getTextLength());
        }
        if (prim != null) {
            for (Map.Entry entry : tags.entrySet()) {
                prim.put((String)entry.getKey(), ((StringBuilder)entry.getValue()).toString());
            }
        }
    }

    private static final class CrsData {
        public CoordinateReferenceSystem crs;
        public MathTransform transform;
        public int dim;

        CrsData(CoordinateReferenceSystem crs, MathTransform transform, int dim) {
            this.crs = crs;
            this.transform = transform;
            this.dim = dim;
        }
    }
}

