/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.tools.UserCancelException;

public final class WayCombiner {
    private WayCombiner() {
    }

    private static Way getTargetWay(Collection<Way> combinedWays) {
        Way targetWay = combinedWays.iterator().next();
        Iterator<Way> iterator = combinedWays.iterator();
        while (iterator.hasNext()) {
            Way w;
            targetWay = w = iterator.next();
            if (w.isNew()) continue;
            break;
        }
        return targetWay;
    }

    public static void combineWays(Collection<Way> ways) throws UserCancelException {
        if (ways == null || ways.isEmpty()) {
            return;
        }
        ways.remove(null);
        ways = new LinkedHashSet<Way>(ways);
        NodeGraph graph = NodeGraph.createUndirectedGraphFromNodeWays(ways);
        List path = graph.buildSpanningPath();
        if (path == null) {
            return;
        }
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        List<Way> reversedWays = new LinkedList();
        List<Way> unreversedWays = new LinkedList();
        for (Way w : ways) {
            if (path.indexOf(w.getNode(0)) + 1 == path.lastIndexOf(w.getNode(1))) {
                unreversedWays.add(w);
                continue;
            }
            reversedWays.add(w);
        }
        if (unreversedWays.isEmpty()) {
            Collections.reverse(path);
            unreversedWays = reversedWays;
            reversedWays = null;
        }
        if (reversedWays != null && !reversedWays.isEmpty()) {
            unreversedWays = ReverseWayTagCorrector.irreversibleWays(unreversedWays);
            if ((reversedWays = ReverseWayTagCorrector.irreversibleWays(reversedWays)).size() > unreversedWays.size()) {
                Collections.reverse(path);
                List<Way> tempWays = unreversedWays;
                unreversedWays = reversedWays;
                reversedWays = tempWays;
            }
            if (!reversedWays.isEmpty()) {
                ArrayList<Way> unreversedTagWays = new ArrayList<Way>(ways);
                unreversedTagWays.removeAll(reversedWays);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                ArrayList<Way> reversedTagWays = new ArrayList<Way>();
                Collection changePropertyCommands = null;
                for (Way w : reversedWays) {
                    Way wnew = new Way(w);
                    reversedTagWays.add(wnew);
                    changePropertyCommands = reverseWayTagCorrector.execute(w, wnew);
                }
                if (changePropertyCommands != null && !changePropertyCommands.isEmpty()) {
                    for (Command c : changePropertyCommands) {
                        c.executeCommand();
                    }
                }
                wayTags = TagCollection.unionOfAllPrimitives(reversedTagWays);
                wayTags.add(TagCollection.unionOfAllPrimitives(unreversedTagWays));
            }
        }
        Way targetWay = WayCombiner.getTargetWay(ways);
        Way modifiedTargetWay = new Way(targetWay);
        modifiedTargetWay.setNodes(path);
        TagCollection completeWayTags = new TagCollection(wayTags);
        TagConflictResolutionUtil.applyAutomaticTagConflictResolution((TagCollection)completeWayTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing((TagCollection)completeWayTags, ways);
        TagCollection tagsToEdit = new TagCollection(completeWayTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing((TagCollection)tagsToEdit);
        CombinePrimitiveResolverDialog dialog = new CombinePrimitiveResolverDialog((Component)MainApplication.getMainFrame());
        dialog.getTagConflictResolverModel().populate(tagsToEdit, completeWayTags.getKeysWithMultipleValues());
        dialog.setTargetPrimitive((OsmPrimitive)targetWay);
        Set parentRelations = OsmPrimitive.getParentRelations(ways);
        dialog.getRelationMemberConflictResolverModel().populate((Collection)parentRelations, ways);
        dialog.prepareDefaultDecisions();
        if (!completeWayTags.isApplicableToPrimitive() || !parentRelations.isEmpty()) {
            dialog.setVisible(true);
            throw new UserCancelException();
        }
        LinkedList<Way> deletedWays = new LinkedList<Way>(ways);
        deletedWays.remove(targetWay);
        targetWay.cloneFrom((OsmPrimitive)modifiedTargetWay);
        for (Way way : deletedWays) {
            way.setNodes(null);
            way.setDeleted(true);
            way.getDataSet().removePrimitive((PrimitiveId)way);
        }
    }
}

