/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.model;

import com.bric.swing.ColorPicker;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.rmi.server.UID;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.rasterfilters.filters.Filter;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FilterGuiListener;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FilterPanel;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FiltersDialog;
import org.openstreetmap.josm.plugins.rasterfilters.model.FilterStateModel;
import org.openstreetmap.josm.plugins.rasterfilters.model.StateChangeListener;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FiltersDownloader;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.Logging;

public class FiltersManager
implements StateChangeListener,
ImageProcessor,
ActionListener,
ItemListener {
    public Map<UID, Filter> filtersMap = new LinkedHashMap<UID, Filter>();
    public Set<Filter> disabledFilters = new HashSet<Filter>();
    public FiltersDialog dialog;

    public FiltersManager(FiltersDialog dialog) {
        this.dialog = dialog;
    }

    private JPanel createFilterWithPanel(JsonObject meta) {
        FilterPanel fp = new FilterPanel();
        FilterGuiListener filterListener = new FilterGuiListener(this);
        String filterClassName = meta.getString("classname");
        String filterTitle = meta.getString("title");
        fp.setName(filterTitle);
        FilterStateModel filterState = new FilterStateModel();
        filterState.setFilterClassName(filterClassName);
        Filter filter = null;
        try {
            Logging.debug((String)("ClassName for loading " + filterState.getFilterClassName()));
            Class<?> clazz = FiltersDownloader.loader.loadClass(filterState.getFilterClassName());
            filter = (Filter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            Logging.error((Throwable)e);
        }
        if (filter != null) {
            UID filterId = new UID();
            fp.setFilterId(filterId);
            filterListener.setFilterId(filterId);
            filter.setId(filterId);
            this.filtersMap.put(filterId, filter);
        }
        fp.setBorder(BorderFactory.createTitledBorder(meta.getString("title")));
        JsonArray controls = meta.getJsonArray("controls");
        for (int i = 0; i < controls.size(); ++i) {
            JsonObject temp = controls.getJsonObject(i);
            JComponent component = fp.addGuiElement(temp);
            if (component == null) continue;
            if (component instanceof JSlider) {
                ((JSlider)component).addChangeListener(filterListener);
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).addItemListener(filterListener);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).addActionListener(filterListener);
            } else if (component instanceof ColorPicker) {
                component.addPropertyChangeListener(filterListener);
            }
            filterState.addParams(temp);
        }
        fp.setNeededHeight(fp.getNeededHeight() + 60);
        fp.setMaximumSize(new Dimension(300, fp.getNeededHeight()));
        fp.setPreferredSize(new Dimension(300, fp.getNeededHeight()));
        if (filter != null) {
            filter.changeFilterState(filterState.encodeJson());
        }
        MainApplication.getLayerManager().getActiveLayer().setFilterStateChanged();
        fp.createBottomPanel(this);
        filterListener.setFilterState(filterState);
        Logging.debug((String)("The number of elems in the Filters map is equal \n" + this.filtersMap.size()));
        return fp;
    }

    @Override
    public void filterStateChanged(UID filterId, FilterStateModel filterState) {
        if (this.filtersMap.get(filterId) != null) {
            this.filtersMap.get(filterId).changeFilterState(filterState.encodeJson());
        }
        if (MainApplication.getLayerManager().getActiveLayer() != null) {
            MainApplication.getLayerManager().getActiveLayer().setFilterStateChanged();
        }
    }

    public JPanel createPanelByTitle(String title) {
        for (JsonObject json : FiltersDownloader.filtersMeta) {
            if (!json.getString("title").equals(title)) continue;
            return this.createFilterWithPanel(json);
        }
        return null;
    }

    public BufferedImage process(BufferedImage image) {
        for (Filter curFilter : this.filtersMap.values()) {
            if (this.disabledFilters.contains(curFilter)) continue;
            BufferedImage oldImg = image;
            if ((image = curFilter.applyFilter(image)) != null) continue;
            image = oldImg;
        }
        return image;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterPanel filterPanel = (FilterPanel)((JButton)e.getSource()).getParent().getParent();
        UID filterId = filterPanel.getFilterId();
        this.filtersMap.remove(filterId);
        this.dialog.getShowedFiltersTitles().remove(filterPanel.getName());
        this.dialog.getListModel().addElement(filterPanel.getName());
        filterPanel.removeAll();
        this.dialog.getFilterContainer().remove(filterPanel);
        if (this.dialog.getFilterContainer().getComponentCount() == 0) {
            this.dialog.deleteFilterContainer();
        } else {
            this.dialog.getFilterContainer().revalidate();
            this.dialog.getFilterContainer().repaint();
        }
        if (!this.dialog.getAddButton().isEnabled()) {
            this.dialog.getFilterChooser().setEnabled(true);
            this.dialog.getAddButton().setEnabled(true);
        }
        MainApplication.getLayerManager().getActiveLayer().setFilterStateChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox enableFilter = (JCheckBox)e.getSource();
        FilterPanel filterPanel = (FilterPanel)enableFilter.getParent().getParent();
        if (enableFilter.isSelected()) {
            UID filterId = filterPanel.getFilterId();
            this.disabledFilters.add(this.filtersMap.get(filterId));
            MainApplication.getLayerManager().getActiveLayer().setFilterStateChanged();
        } else {
            UID filterId = filterPanel.getFilterId();
            this.disabledFilters.remove(this.filtersMap.get(filterId));
            MainApplication.getLayerManager().getActiveLayer().setFilterStateChanged();
        }
    }
}

