/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortOrder {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private static final int DEFAULT_NULL_SORT = SysProperties.SORT_NULLS_HIGH ? 1 : -1;
    private final Database database;
    private final int len;
    private final int[] indexes;
    private final int[] sortTypes;

    public SortOrder(Database database, int[] nArray, int[] nArray2) {
        this.database = database;
        this.indexes = nArray;
        this.sortTypes = nArray2;
        this.len = nArray.length;
    }

    public String getSQL(Expression[] expressionArray, int n) {
        StatementBuilder statementBuilder = new StatementBuilder();
        int n2 = 0;
        for (int n3 : this.indexes) {
            statementBuilder.appendExceptFirst(", ");
            if (n3 < n) {
                statementBuilder.append(n3 + 1);
            } else {
                statementBuilder.append('=').append(StringUtils.unEnclose(expressionArray[n3].getSQL()));
            }
            int n4 = this.sortTypes[n2++];
            if ((n4 & 1) != 0) {
                statementBuilder.append(" DESC");
            }
            if ((n4 & 2) != 0) {
                statementBuilder.append(" NULLS FIRST");
                continue;
            }
            if ((n4 & 4) == 0) continue;
            statementBuilder.append(" NULLS LAST");
        }
        return statementBuilder.toString();
    }

    public static int compareNull(boolean bl, boolean bl2, int n) {
        if ((n & 2) != 0) {
            return bl ? -1 : 1;
        }
        if ((n & 4) != 0) {
            return bl ? 1 : -1;
        }
        int n2 = bl ? DEFAULT_NULL_SORT : -DEFAULT_NULL_SORT;
        return (n & 1) == 0 ? n2 : -n2;
    }

    public int compare(Value[] valueArray, Value[] valueArray2) throws SQLException {
        for (int i = 0; i < this.len; ++i) {
            boolean bl;
            int n = this.indexes[i];
            int n2 = this.sortTypes[i];
            Value value = valueArray[n];
            Value value2 = valueArray2[n];
            boolean bl2 = value == ValueNull.INSTANCE;
            boolean bl3 = bl = value2 == ValueNull.INSTANCE;
            if (bl2 || bl) {
                if (bl2 == bl) continue;
                return SortOrder.compareNull(bl2, bl, n2);
            }
            int n3 = this.database.compare(value, value2);
            if (n3 == 0) continue;
            return (n2 & 1) == 0 ? n3 : -n3;
        }
        return 0;
    }

    public void sort(ObjectArray<Value[]> objectArray) throws SQLException {
        this.sort(objectArray, 0, objectArray.size() - 1);
    }

    private void swap(ObjectArray<Value[]> objectArray, int n, int n2) {
        Value[] valueArray = objectArray.get(n);
        objectArray.set(n, objectArray.get(n2));
        objectArray.set(n2, valueArray);
    }

    private void sort(ObjectArray<Value[]> objectArray, int n, int n2) throws SQLException {
        Value[] valueArray;
        int n3;
        int n4;
        while (n2 - n > 10) {
            n4 = RandomUtils.nextInt(n2 - n - 4) + n + 2;
            if (this.compare(objectArray.get(n), objectArray.get(n2)) > 0) {
                this.swap(objectArray, n, n2);
            }
            if (this.compare(objectArray.get(n4), objectArray.get(n)) < 0) {
                this.swap(objectArray, n, n4);
            } else if (this.compare(objectArray.get(n4), objectArray.get(n2)) > 0) {
                this.swap(objectArray, n4, n2);
            }
            n3 = n2 - 1;
            this.swap(objectArray, n4, n3);
            valueArray = objectArray.get(n3);
            n4 = n;
            while (true) {
                if (this.compare(objectArray.get(++n4), valueArray) < 0) {
                    continue;
                }
                while (this.compare(objectArray.get(--n3), valueArray) > 0) {
                }
                if (n4 >= n3) break;
                this.swap(objectArray, n4, n3);
            }
            this.swap(objectArray, n4, n2 - 1);
            this.sort(objectArray, n, n4 - 1);
            n = n4 + 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            valueArray = objectArray.get(n4);
            for (n3 = n4 - 1; n3 >= n && this.compare(objectArray.get(n3), valueArray) > 0; --n3) {
                objectArray.set(n3 + 1, objectArray.get(n3));
            }
            objectArray.set(n3 + 1, valueArray);
        }
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }
}

