/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Font;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Utilities;

public class FontImpl
implements Font,
Cloneable {
    private final List<Expression> fontFamily = new ArrayList<Expression>();
    private Expression fontSize = null;
    private Expression fontStyle = null;
    private Expression fontWeight = null;

    protected FontImpl() {
    }

    @Override
    public List<Expression> getFamily() {
        return this.fontFamily;
    }

    @Override
    public Expression getSize() {
        return this.fontSize;
    }

    @Override
    public void setSize(Expression size) {
        this.fontSize = size;
    }

    @Override
    public Expression getStyle() {
        return this.fontStyle;
    }

    @Override
    public void setStyle(Expression style) {
        this.fontStyle = style;
    }

    @Override
    public Expression getWeight() {
        return this.fontWeight;
    }

    @Override
    public void setWeight(Expression weight) {
        this.fontWeight = weight;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should not happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fontFamily != null) {
            result = 1000003 * result + this.fontFamily.hashCode();
        }
        if (this.fontSize != null) {
            result = 1000003 * result + this.fontSize.hashCode();
        }
        if (this.fontStyle != null) {
            result = 1000003 * result + this.fontStyle.hashCode();
        }
        if (this.fontWeight != null) {
            result = 1000003 * result + this.fontWeight.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof FontImpl) {
            FontImpl other = (FontImpl)oth;
            return Utilities.equals(this.fontFamily, other.fontFamily) && Utilities.equals(this.fontSize, other.fontSize) && Utilities.equals(this.fontStyle, other.fontStyle) && Utilities.equals(this.fontWeight, other.fontWeight);
        }
        return false;
    }

    static Font createDefault(FilterFactory filterFactory) {
        FontImpl font = new FontImpl();
        try {
            font.setSize(filterFactory.literal((Object)10));
            font.setStyle(filterFactory.literal("normal"));
            font.setWeight(filterFactory.literal("normal"));
            font.getFamily().add(filterFactory.literal("Serif"));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating default", ife);
        }
        return font;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    static FontImpl cast(Font font) {
        if (font == null) {
            return null;
        }
        if (font instanceof FontImpl) {
            return (FontImpl)font;
        }
        FontImpl copy = new FontImpl();
        copy.getFamily().addAll(font.getFamily());
        copy.setSize(font.getSize());
        copy.setStyle(font.getStyle());
        copy.setWeight(font.getWeight());
        return copy;
    }
}

