/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class CylindricalEqualArea
extends MapProjection {
    private static final double DTR = Math.PI / 180;
    private static final double HALFPI = 1.5707963267948966;
    private double qp;
    private double[] apa;
    private double es;
    private double e;
    private double one_es;
    private double trueScaleLatitude;
    private double trueScaleLatitudeDeg;

    protected CylindricalEqualArea(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        this.trueScaleLatitudeDeg = parameters.parameter("standard_parallel_1").doubleValue();
        this.trueScaleLatitude = Math.PI / 180 * this.trueScaleLatitude;
        this.es = this.excentricitySquared;
        this.e = this.excentricity;
        this.one_es = 1.0 - this.excentricitySquared;
        double t = this.trueScaleLatitude;
        this.scaleFactor = Math.cos(t);
        if (this.es != 0.0) {
            t = Math.sin(t);
            this.scaleFactor /= Math.sqrt(1.0 - this.es * t * t);
            this.e = Math.sqrt(this.es);
            this.apa = ProjectionMath.authset(this.es);
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        values.parameter("standard_parallel_1").setValue(this.trueScaleLatitudeDeg);
        return values;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D xy) throws ProjectionException {
        double y;
        double x;
        if (this.isSpherical) {
            x = this.scaleFactor * lam;
            y = Math.sin(phi) / this.scaleFactor;
        } else {
            x = this.scaleFactor * lam;
            y = 0.5 * ProjectionMath.qsfn(Math.sin(phi), this.e, this.one_es) / this.scaleFactor;
        }
        if (xy != null) {
            xy.setLocation(x, y);
            return xy;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D lp) throws ProjectionException {
        double lam;
        double phi;
        if (this.isSpherical) {
            double t = Math.abs(y *= this.scaleFactor);
            phi = t >= 1.0 ? (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(y);
            lam = x / this.scaleFactor;
        } else {
            phi = ProjectionMath.authlat(Math.asin(2.0 * y * this.scaleFactor / this.qp), this.apa);
            lam = x / this.scaleFactor;
        }
        if (lp != null) {
            lp.setLocation(lam, phi);
            return lp;
        }
        return new Point2D.Double(lam, phi);
    }

    private static class ProjectionMath {
        private static final double P00 = 0.3333333333333333;
        private static final double P01 = 0.17222222222222222;
        private static final double P02 = 0.10257936507936508;
        private static final double P10 = 0.06388888888888888;
        private static final double P11 = 0.0664021164021164;
        private static final double P20 = 0.016415012942191543;

        private ProjectionMath() {
        }

        public static double[] authset(double es) {
            double[] APA = new double[3];
            APA[0] = es * 0.3333333333333333;
            double t = es * es;
            APA[0] = APA[0] + t * 0.17222222222222222;
            APA[1] = t * 0.06388888888888888;
            APA[0] = APA[0] + (t *= es) * 0.10257936507936508;
            APA[1] = APA[1] + t * 0.0664021164021164;
            APA[2] = t * 0.016415012942191543;
            return APA;
        }

        public static double qsfn(double sinphi, double e, double one_es) {
            if (e >= 1.0E-7) {
                double con = e * sinphi;
                return one_es * (sinphi / (1.0 - con * con) - 0.5 / e * Math.log((1.0 - con) / (1.0 + con)));
            }
            return sinphi + sinphi;
        }

        public static double authlat(double beta, double[] APA) {
            double t = beta + beta;
            return beta + APA[0] * Math.sin(t) + APA[1] * Math.sin(t + t) + APA[2] * Math.sin(t + t + t);
        }
    }

    public static class LambertCylindricalEqualAreaProvider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = LambertCylindricalEqualAreaProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Lambert Cylindrical Equal Area (Spherical)")}, Provider.getParameterDescriptors());

        public LambertCylindricalEqualAreaProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            return new CylindricalEqualArea(parameters);
        }
    }

    public static class BehrmannProvider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = BehrmannProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Behrmann"), new NamedIdentifier(Citations.ESRI, "54017")}, Provider.getParameterDescriptors());

        public BehrmannProvider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            parameters.parameter("standard_parallel_1").setValue(30);
            return new CylindricalEqualArea(parameters);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Cylindrical_Equal_Area"), new NamedIdentifier(Citations.OGC, "Cylindrical_Equal_Area"), new NamedIdentifier(Citations.ESRI, "Cylindrical_Equal_Area"), new NamedIdentifier(Citations.GEOTIFF, "CT_CylindricalEqualArea")}, Provider.getParameterDescriptors());

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            return new CylindricalEqualArea(parameters);
        }

        protected static ParameterDescriptor[] getParameterDescriptors() {
            return new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL_1, FALSE_EASTING, FALSE_NORTHING};
        }
    }
}

