/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class SurfaceTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gf;

    public SurfaceTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    @Override
    public QName getTarget() {
        return GML.SurfaceType;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return MultiPolygon.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Polygon[] patches = node.getChildValue(Polygon[].class);
        MultiPolygon mp = node.getChildValue(MultiPolygon.class);
        if (mp != null) {
            return mp;
        }
        return this.gf.createMultiPolygon(patches);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if ("patches".equals(name.getLocalPart())) {
            MultiPolygon multiSurface = (MultiPolygon)object;
            Polygon[] members = new Polygon[multiSurface.getNumGeometries()];
            for (int i = 0; i < members.length; ++i) {
                members[i] = (Polygon)multiSurface.getGeometryN(i);
            }
            return members;
        }
        return null;
    }
}

