/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.AbstractPosition;
import org.geotools.util.Utilities;

public class Position3D
implements Position,
Serializable,
Cloneable {
    public double x;
    public double y;
    public double z;
    private static final long serialVersionUID = 835130287438466996L;
    private CoordinateReferenceSystem crs;

    public Position3D() {
    }

    public Position3D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public Position3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Position3D(CoordinateReferenceSystem crs, double x, double y, double z) {
        this(x, y, z);
        this.setCoordinateReferenceSystem(crs);
    }

    public Position3D(Position point) {
        this.setLocation(point);
    }

    @Override
    public Position getDirectPosition() {
        return this;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        AbstractPosition.checkCoordinateReferenceSystemDimension(crs, 3);
        this.crs = crs;
    }

    @Override
    public final int getDimension() {
        return 3;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(dimension));
            }
        }
    }

    public void setLocation(Position position) throws MismatchedDimensionException {
        AbstractPosition.ensureDimensionMatch("position", position.getDimension(), 3);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.x = position.getOrdinate(0);
        this.y = position.getOrdinate(1);
        this.z = position.getOrdinate(2);
    }

    public String toString() {
        return AbstractPosition.toString(this);
    }

    @Override
    public int hashCode() {
        return AbstractPosition.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Position) {
            Position other = (Position)object;
            if (other.getDimension() == 3 && Utilities.equals(other.getOrdinate(0), this.x) && Utilities.equals(other.getOrdinate(1), this.y) && Utilities.equals(other.getOrdinate(2), this.z) && Utilities.equals(other.getCoordinateReferenceSystem(), this.crs)) {
                assert (this.hashCode() == other.hashCode()) : this;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Position3D clone() {
        return new Position3D(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }
}

