/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.AbstractPosition;
import org.geotools.util.Utilities;

public class Position2D
extends Point2D.Double
implements Position,
Serializable,
Cloneable {
    private static final long serialVersionUID = 835130287438466996L;
    private CoordinateReferenceSystem crs;

    public Position2D() {
    }

    public Position2D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public Position2D(double x, double y) {
        super(x, y);
    }

    public Position2D(CoordinateReferenceSystem crs, double x, double y) {
        super(x, y);
        this.setCoordinateReferenceSystem(crs);
    }

    public Position2D(Point2D point) {
        super(point.getX(), point.getY());
        if (point instanceof Position) {
            this.setCoordinateReferenceSystem(((Position)((Object)point)).getCoordinateReferenceSystem());
        }
    }

    public Position2D(Position point) {
        this.setLocation(point);
    }

    @Override
    public Position getDirectPosition() {
        return this;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        AbstractPosition.checkCoordinateReferenceSystemDimension(crs, 2);
        this.crs = crs;
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    @Override
    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(dimension));
            }
        }
    }

    public void setLocation(Position position) throws MismatchedDimensionException {
        AbstractPosition.ensureDimensionMatch("position", position.getDimension(), 2);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.x = position.getOrdinate(0);
        this.y = position.getOrdinate(1);
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public String toString() {
        return AbstractPosition.toString(this);
    }

    @Override
    public int hashCode() {
        return AbstractPosition.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Position) {
            Position other = (Position)object;
            if (other.getDimension() == 2 && Utilities.equals(other.getOrdinate(0), this.x) && Utilities.equals(other.getOrdinate(1), this.y) && Utilities.equals(other.getCoordinateReferenceSystem(), this.crs)) {
                assert (this.hashCode() == other.hashCode()) : this;
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Position2D clone() {
        return (Position2D)super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = in.readDouble();
        this.y = in.readDouble();
    }
}

