/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.filter.v1_1.OGC;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class SortPropertyTypeBinding
extends AbstractComplexBinding {
    FilterFactory filterfactory;

    public SortPropertyTypeBinding(FilterFactory filterfactory) {
        this.filterfactory = filterfactory;
    }

    @Override
    public QName getTarget() {
        return OGC.SortPropertyType;
    }

    public Class getType() {
        return SortBy.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        PropertyName name = node.getChildValue(PropertyName.class);
        SortOrder order = node.getChildValue(SortOrder.class);
        if (order == null) {
            order = SortOrder.ASCENDING;
        }
        return this.filterfactory.sort(name.getPropertyName(), order);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        SortBy sortBy = (SortBy)object;
        if (OGC.PropertyName.equals(name)) {
            return sortBy.getPropertyName();
        }
        if ("SortOrder".equals(name.getLocalPart())) {
            return sortBy.getSortOrder();
        }
        return null;
    }
}

