/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.FeatureImplUtils;
import org.geotools.feature.type.AttributeDescriptorImpl;

public class ComplexAttributeImpl
extends AttributeImpl
implements ComplexAttribute {
    public ComplexAttributeImpl(Collection<Property> properties, AttributeDescriptor descriptor, Identifier id) {
        super(ComplexAttributeImpl.cloneProperties(properties), descriptor, id);
    }

    public ComplexAttributeImpl(Collection<Property> properties, ComplexType type, Identifier id) {
        this(properties, (AttributeDescriptor)new AttributeDescriptorImpl(type, type.getName(), 1, 1, true, null), id);
    }

    @Override
    public ComplexType getType() {
        return (ComplexType)super.getType();
    }

    @Override
    public Collection<? extends Property> getValue() {
        Collection cast = (Collection)super.getValue();
        return FeatureImplUtils.unmodifiable(cast);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection cast = (Collection)super.getValue();
        return FeatureImplUtils.unmodifiable(cast);
    }

    protected Collection properties() {
        return (Collection)super.getValue();
    }

    @Override
    public Collection<Property> getProperties(Name name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(name)) continue;
            matches.add(property);
        }
        return matches;
    }

    @Override
    public Collection<Property> getProperties(String name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Object o : this.properties()) {
            Property property = (Property)o;
            if (!property.getName().getLocalPart().equals(name)) continue;
            matches.add(property);
        }
        return matches;
    }

    @Override
    public Property getProperty(Name name) {
        for (Object o : this.properties()) {
            Property property = (Property)o;
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public Property getProperty(String name) {
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().getLocalPart().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        Collection cast = (Collection)newValue;
        this.setValue(cast);
    }

    @Override
    public void setValue(Collection<Property> newValue) {
        super.setValue(ComplexAttributeImpl.cloneProperties(newValue));
    }

    private static <T> Collection<T> cloneProperties(Collection<T> original) {
        if (original == null) {
            return null;
        }
        ArrayList<T> clone = new ArrayList<T>();
        clone.addAll(original);
        return clone;
    }
}

