/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorconvert;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class ColorConvertDescriptor
extends OperationDescriptorImpl {
    public ColorConvertDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "ColorConvert"}, {"LocalName", "ColorConvert"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Converts the colorspace of an Image taking into account ROI and NoData"}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ColorConvertDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "Destination ColorModel"}, {"arg1Desc", "Input ROI used in calculations"}, {"arg2Desc", "No data range used for checking if the a pixel is a nodata"}, {"arg3Desc", "Output value for nodata"}}, 1, new Class[]{ColorModel.class, ROI.class, Range.class, double[].class}, new String[]{"colorModel", "roi", "nodata", "destNoData"}, new Object[]{NO_PARAMETER_DEFAULT, null, null, new double[]{0.0}});
    }

    @Override
    public boolean isRenderableSupported() {
        return true;
    }

    public static RenderedOp create(RenderedImage source0, ColorModel colorModel, ROI roi, Range nodata, double[] destinationNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ColorConvert", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("colorModel", colorModel);
        pb.setParameter("roi", roi);
        pb.setParameter("nodata", nodata);
        pb.setParameter("destNoData", destinationNoData);
        return JAI.create("ColorConvert", pb, hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, ColorModel colorModel, ROI roi, Range nodata, double[] destinationNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ColorConvert", "renderable");
        pb.setSource("source0", source0);
        pb.setParameter("colorModel", colorModel);
        pb.setParameter("roi", roi);
        pb.setParameter("nodata", nodata);
        pb.setParameter("destNoData", destinationNoData);
        return JAI.createRenderable("ColorConvert", pb, hints);
    }
}

