/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoDecodeCapabilitiesKHR;
import org.lwjgl.vulkan.VkVideoDecodeH264CapabilitiesKHR;
import org.lwjgl.vulkan.VkVideoDecodeH265CapabilitiesKHR;
import org.lwjgl.vulkan.VkVideoEncodeCapabilitiesKHR;
import org.lwjgl.vulkan.VkVideoEncodeH264CapabilitiesEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265CapabilitiesEXT;

public class VkVideoCapabilitiesKHR
extends Struct<VkVideoCapabilitiesKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MINBITSTREAMBUFFEROFFSETALIGNMENT;
    public static final int MINBITSTREAMBUFFERSIZEALIGNMENT;
    public static final int PICTUREACCESSGRANULARITY;
    public static final int MINCODEDEXTENT;
    public static final int MAXCODEDEXTENT;
    public static final int MAXDPBSLOTS;
    public static final int MAXACTIVEREFERENCEPICTURES;
    public static final int STDHEADERVERSION;

    protected VkVideoCapabilitiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoCapabilitiesKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoCapabilitiesKHR(address, container);
    }

    public VkVideoCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoCapabilitiesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkVideoCapabilitiesKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoCapabilityFlagsKHR")
    public int flags() {
        return VkVideoCapabilitiesKHR.nflags(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minBitstreamBufferOffsetAlignment() {
        return VkVideoCapabilitiesKHR.nminBitstreamBufferOffsetAlignment(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long minBitstreamBufferSizeAlignment() {
        return VkVideoCapabilitiesKHR.nminBitstreamBufferSizeAlignment(this.address());
    }

    public VkExtent2D pictureAccessGranularity() {
        return VkVideoCapabilitiesKHR.npictureAccessGranularity(this.address());
    }

    public VkExtent2D minCodedExtent() {
        return VkVideoCapabilitiesKHR.nminCodedExtent(this.address());
    }

    public VkExtent2D maxCodedExtent() {
        return VkVideoCapabilitiesKHR.nmaxCodedExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDpbSlots() {
        return VkVideoCapabilitiesKHR.nmaxDpbSlots(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxActiveReferencePictures() {
        return VkVideoCapabilitiesKHR.nmaxActiveReferencePictures(this.address());
    }

    public VkExtensionProperties stdHeaderVersion() {
        return VkVideoCapabilitiesKHR.nstdHeaderVersion(this.address());
    }

    public VkVideoCapabilitiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoCapabilitiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoCapabilitiesKHR sType$Default() {
        return this.sType(1000023001);
    }

    public VkVideoCapabilitiesKHR pNext(@NativeType(value="void *") long value) {
        VkVideoCapabilitiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoDecodeCapabilitiesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoDecodeH264CapabilitiesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoDecodeH265CapabilitiesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoEncodeCapabilitiesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoEncodeH264CapabilitiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR pNext(VkVideoEncodeH265CapabilitiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoCapabilitiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkVideoCapabilitiesKHR set(VkVideoCapabilitiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoCapabilitiesKHR malloc() {
        return new VkVideoCapabilitiesKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoCapabilitiesKHR calloc() {
        return new VkVideoCapabilitiesKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoCapabilitiesKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoCapabilitiesKHR create(long address) {
        return new VkVideoCapabilitiesKHR(address, null);
    }

    @Nullable
    public static VkVideoCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoCapabilitiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoCapabilitiesKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoCapabilitiesKHR malloc(MemoryStack stack) {
        return new VkVideoCapabilitiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoCapabilitiesKHR calloc(MemoryStack stack) {
        return new VkVideoCapabilitiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nminBitstreamBufferOffsetAlignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINBITSTREAMBUFFEROFFSETALIGNMENT);
    }

    public static long nminBitstreamBufferSizeAlignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINBITSTREAMBUFFERSIZEALIGNMENT);
    }

    public static VkExtent2D npictureAccessGranularity(long struct) {
        return VkExtent2D.create(struct + (long)PICTUREACCESSGRANULARITY);
    }

    public static VkExtent2D nminCodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINCODEDEXTENT);
    }

    public static VkExtent2D nmaxCodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXCODEDEXTENT);
    }

    public static int nmaxDpbSlots(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDPBSLOTS);
    }

    public static int nmaxActiveReferencePictures(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXACTIVEREFERENCEPICTURES);
    }

    public static VkExtensionProperties nstdHeaderVersion(long struct) {
        return VkExtensionProperties.create(struct + (long)STDHEADERVERSION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkVideoCapabilitiesKHR.__struct(VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(POINTER_SIZE), VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(8), VkVideoCapabilitiesKHR.__member(8), VkVideoCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(4), VkVideoCapabilitiesKHR.__member(VkExtensionProperties.SIZEOF, VkExtensionProperties.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MINBITSTREAMBUFFEROFFSETALIGNMENT = layout.offsetof(3);
        MINBITSTREAMBUFFERSIZEALIGNMENT = layout.offsetof(4);
        PICTUREACCESSGRANULARITY = layout.offsetof(5);
        MINCODEDEXTENT = layout.offsetof(6);
        MAXCODEDEXTENT = layout.offsetof(7);
        MAXDPBSLOTS = layout.offsetof(8);
        MAXACTIVEREFERENCEPICTURES = layout.offsetof(9);
        STDHEADERVERSION = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkVideoCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkVideoCapabilitiesKHR ELEMENT_FACTORY = VkVideoCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoCapabilitiesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkVideoCapabilitiesKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoCapabilityFlagsKHR")
        public int flags() {
            return VkVideoCapabilitiesKHR.nflags(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minBitstreamBufferOffsetAlignment() {
            return VkVideoCapabilitiesKHR.nminBitstreamBufferOffsetAlignment(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long minBitstreamBufferSizeAlignment() {
            return VkVideoCapabilitiesKHR.nminBitstreamBufferSizeAlignment(this.address());
        }

        public VkExtent2D pictureAccessGranularity() {
            return VkVideoCapabilitiesKHR.npictureAccessGranularity(this.address());
        }

        public VkExtent2D minCodedExtent() {
            return VkVideoCapabilitiesKHR.nminCodedExtent(this.address());
        }

        public VkExtent2D maxCodedExtent() {
            return VkVideoCapabilitiesKHR.nmaxCodedExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDpbSlots() {
            return VkVideoCapabilitiesKHR.nmaxDpbSlots(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxActiveReferencePictures() {
            return VkVideoCapabilitiesKHR.nmaxActiveReferencePictures(this.address());
        }

        public VkExtensionProperties stdHeaderVersion() {
            return VkVideoCapabilitiesKHR.nstdHeaderVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoCapabilitiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkVideoCapabilitiesKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoDecodeCapabilitiesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH264CapabilitiesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265CapabilitiesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeCapabilitiesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264CapabilitiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265CapabilitiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

