/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVertexInputAttributeDescription
extends Struct<VkVertexInputAttributeDescription>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int BINDING;
    public static final int FORMAT;
    public static final int OFFSET;

    protected VkVertexInputAttributeDescription(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVertexInputAttributeDescription create(long address, @Nullable ByteBuffer container) {
        return new VkVertexInputAttributeDescription(address, container);
    }

    public VkVertexInputAttributeDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVertexInputAttributeDescription.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int location() {
        return VkVertexInputAttributeDescription.nlocation(this.address());
    }

    @NativeType(value="uint32_t")
    public int binding() {
        return VkVertexInputAttributeDescription.nbinding(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkVertexInputAttributeDescription.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkVertexInputAttributeDescription.noffset(this.address());
    }

    public VkVertexInputAttributeDescription location(@NativeType(value="uint32_t") int value) {
        VkVertexInputAttributeDescription.nlocation(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription binding(@NativeType(value="uint32_t") int value) {
        VkVertexInputAttributeDescription.nbinding(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription format(@NativeType(value="VkFormat") int value) {
        VkVertexInputAttributeDescription.nformat(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription offset(@NativeType(value="uint32_t") int value) {
        VkVertexInputAttributeDescription.noffset(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription set(int location, int binding, int format, int offset) {
        this.location(location);
        this.binding(binding);
        this.format(format);
        this.offset(offset);
        return this;
    }

    public VkVertexInputAttributeDescription set(VkVertexInputAttributeDescription src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVertexInputAttributeDescription malloc() {
        return new VkVertexInputAttributeDescription(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVertexInputAttributeDescription calloc() {
        return new VkVertexInputAttributeDescription(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVertexInputAttributeDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVertexInputAttributeDescription(MemoryUtil.memAddress(container), container);
    }

    public static VkVertexInputAttributeDescription create(long address) {
        return new VkVertexInputAttributeDescription(address, null);
    }

    @Nullable
    public static VkVertexInputAttributeDescription createSafe(long address) {
        return address == 0L ? null : new VkVertexInputAttributeDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVertexInputAttributeDescription.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVertexInputAttributeDescription.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkVertexInputAttributeDescription mallocStack() {
        return VkVertexInputAttributeDescription.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkVertexInputAttributeDescription callocStack() {
        return VkVertexInputAttributeDescription.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkVertexInputAttributeDescription mallocStack(MemoryStack stack) {
        return VkVertexInputAttributeDescription.malloc(stack);
    }

    @Deprecated
    public static VkVertexInputAttributeDescription callocStack(MemoryStack stack) {
        return VkVertexInputAttributeDescription.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkVertexInputAttributeDescription.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkVertexInputAttributeDescription.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkVertexInputAttributeDescription.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkVertexInputAttributeDescription.calloc(capacity, stack);
    }

    public static VkVertexInputAttributeDescription malloc(MemoryStack stack) {
        return new VkVertexInputAttributeDescription(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVertexInputAttributeDescription calloc(MemoryStack stack) {
        return new VkVertexInputAttributeDescription(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void nbinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDING, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = VkVertexInputAttributeDescription.__struct(VkVertexInputAttributeDescription.__member(4), VkVertexInputAttributeDescription.__member(4), VkVertexInputAttributeDescription.__member(4), VkVertexInputAttributeDescription.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        BINDING = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkVertexInputAttributeDescription, Buffer>
    implements NativeResource {
        private static final VkVertexInputAttributeDescription ELEMENT_FACTORY = VkVertexInputAttributeDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVertexInputAttributeDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int location() {
            return VkVertexInputAttributeDescription.nlocation(this.address());
        }

        @NativeType(value="uint32_t")
        public int binding() {
            return VkVertexInputAttributeDescription.nbinding(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkVertexInputAttributeDescription.nformat(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkVertexInputAttributeDescription.noffset(this.address());
        }

        public Buffer location(@NativeType(value="uint32_t") int value) {
            VkVertexInputAttributeDescription.nlocation(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="uint32_t") int value) {
            VkVertexInputAttributeDescription.nbinding(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkVertexInputAttributeDescription.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkVertexInputAttributeDescription.noffset(this.address(), value);
            return this;
        }
    }
}

