/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCommandBufferSubmitInfo;
import org.lwjgl.vulkan.VkFrameBoundaryEXT;
import org.lwjgl.vulkan.VkPerformanceQuerySubmitInfoKHR;
import org.lwjgl.vulkan.VkSemaphoreSubmitInfo;
import org.lwjgl.vulkan.VkWin32KeyedMutexAcquireReleaseInfoKHR;
import org.lwjgl.vulkan.VkWin32KeyedMutexAcquireReleaseInfoNV;

public class VkSubmitInfo2
extends Struct<VkSubmitInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int WAITSEMAPHOREINFOCOUNT;
    public static final int PWAITSEMAPHOREINFOS;
    public static final int COMMANDBUFFERINFOCOUNT;
    public static final int PCOMMANDBUFFERINFOS;
    public static final int SIGNALSEMAPHOREINFOCOUNT;
    public static final int PSIGNALSEMAPHOREINFOS;

    protected VkSubmitInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubmitInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkSubmitInfo2(address, container);
    }

    public VkSubmitInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubmitInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubmitInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubmitInfo2.npNext(this.address());
    }

    @NativeType(value="VkSubmitFlags")
    public int flags() {
        return VkSubmitInfo2.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreInfoCount() {
        return VkSubmitInfo2.nwaitSemaphoreInfoCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphoreSubmitInfo const *")
    public VkSemaphoreSubmitInfo.Buffer pWaitSemaphoreInfos() {
        return VkSubmitInfo2.npWaitSemaphoreInfos(this.address());
    }

    @NativeType(value="uint32_t")
    public int commandBufferInfoCount() {
        return VkSubmitInfo2.ncommandBufferInfoCount(this.address());
    }

    @Nullable
    @NativeType(value="VkCommandBufferSubmitInfo const *")
    public VkCommandBufferSubmitInfo.Buffer pCommandBufferInfos() {
        return VkSubmitInfo2.npCommandBufferInfos(this.address());
    }

    @NativeType(value="uint32_t")
    public int signalSemaphoreInfoCount() {
        return VkSubmitInfo2.nsignalSemaphoreInfoCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphoreSubmitInfo const *")
    public VkSemaphoreSubmitInfo.Buffer pSignalSemaphoreInfos() {
        return VkSubmitInfo2.npSignalSemaphoreInfos(this.address());
    }

    public VkSubmitInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkSubmitInfo2.nsType(this.address(), value);
        return this;
    }

    public VkSubmitInfo2 sType$Default() {
        return this.sType(1000314004);
    }

    public VkSubmitInfo2 pNext(@NativeType(value="void const *") long value) {
        VkSubmitInfo2.npNext(this.address(), value);
        return this;
    }

    public VkSubmitInfo2 pNext(VkFrameBoundaryEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo2 pNext(VkPerformanceQuerySubmitInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo2 pNext(VkWin32KeyedMutexAcquireReleaseInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo2 pNext(VkWin32KeyedMutexAcquireReleaseInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo2 flags(@NativeType(value="VkSubmitFlags") int value) {
        VkSubmitInfo2.nflags(this.address(), value);
        return this;
    }

    public VkSubmitInfo2 pWaitSemaphoreInfos(@Nullable @NativeType(value="VkSemaphoreSubmitInfo const *") VkSemaphoreSubmitInfo.Buffer value) {
        VkSubmitInfo2.npWaitSemaphoreInfos(this.address(), value);
        return this;
    }

    public VkSubmitInfo2 pCommandBufferInfos(@Nullable @NativeType(value="VkCommandBufferSubmitInfo const *") VkCommandBufferSubmitInfo.Buffer value) {
        VkSubmitInfo2.npCommandBufferInfos(this.address(), value);
        return this;
    }

    public VkSubmitInfo2 pSignalSemaphoreInfos(@Nullable @NativeType(value="VkSemaphoreSubmitInfo const *") VkSemaphoreSubmitInfo.Buffer value) {
        VkSubmitInfo2.npSignalSemaphoreInfos(this.address(), value);
        return this;
    }

    public VkSubmitInfo2 set(int sType, long pNext, int flags, @Nullable VkSemaphoreSubmitInfo.Buffer pWaitSemaphoreInfos, @Nullable VkCommandBufferSubmitInfo.Buffer pCommandBufferInfos, @Nullable VkSemaphoreSubmitInfo.Buffer pSignalSemaphoreInfos) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pWaitSemaphoreInfos(pWaitSemaphoreInfos);
        this.pCommandBufferInfos(pCommandBufferInfos);
        this.pSignalSemaphoreInfos(pSignalSemaphoreInfos);
        return this;
    }

    public VkSubmitInfo2 set(VkSubmitInfo2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubmitInfo2 malloc() {
        return new VkSubmitInfo2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubmitInfo2 calloc() {
        return new VkSubmitInfo2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubmitInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubmitInfo2(MemoryUtil.memAddress(container), container);
    }

    public static VkSubmitInfo2 create(long address) {
        return new VkSubmitInfo2(address, null);
    }

    @Nullable
    public static VkSubmitInfo2 createSafe(long address) {
        return address == 0L ? null : new VkSubmitInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubmitInfo2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubmitInfo2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSubmitInfo2 malloc(MemoryStack stack) {
        return new VkSubmitInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubmitInfo2 calloc(MemoryStack stack) {
        return new VkSubmitInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nwaitSemaphoreInfoCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WAITSEMAPHOREINFOCOUNT);
    }

    @Nullable
    public static VkSemaphoreSubmitInfo.Buffer npWaitSemaphoreInfos(long struct) {
        return VkSemaphoreSubmitInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHOREINFOS), VkSubmitInfo2.nwaitSemaphoreInfoCount(struct));
    }

    public static int ncommandBufferInfoCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMMANDBUFFERINFOCOUNT);
    }

    @Nullable
    public static VkCommandBufferSubmitInfo.Buffer npCommandBufferInfos(long struct) {
        return VkCommandBufferSubmitInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERINFOS), VkSubmitInfo2.ncommandBufferInfoCount(struct));
    }

    public static int nsignalSemaphoreInfoCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIGNALSEMAPHOREINFOCOUNT);
    }

    @Nullable
    public static VkSemaphoreSubmitInfo.Buffer npSignalSemaphoreInfos(long struct) {
        return VkSemaphoreSubmitInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHOREINFOS), VkSubmitInfo2.nsignalSemaphoreInfoCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nwaitSemaphoreInfoCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WAITSEMAPHOREINFOCOUNT, value);
    }

    public static void npWaitSemaphoreInfos(long struct, @Nullable VkSemaphoreSubmitInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHOREINFOS, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo2.nwaitSemaphoreInfoCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncommandBufferInfoCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMMANDBUFFERINFOCOUNT, value);
    }

    public static void npCommandBufferInfos(long struct, @Nullable VkCommandBufferSubmitInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOMMANDBUFFERINFOS, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo2.ncommandBufferInfoCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreInfoCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIGNALSEMAPHOREINFOCOUNT, value);
    }

    public static void npSignalSemaphoreInfos(long struct, @Nullable VkSemaphoreSubmitInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSIGNALSEMAPHOREINFOS, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo2.nsignalSemaphoreInfoCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int commandBufferInfoCount;
        if (VkSubmitInfo2.nwaitSemaphoreInfoCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHOREINFOS));
        }
        if ((commandBufferInfoCount = VkSubmitInfo2.ncommandBufferInfoCount(struct)) != 0) {
            long pCommandBufferInfos = MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERINFOS);
            Checks.check(pCommandBufferInfos);
            VkSubmitInfo2.validate(pCommandBufferInfos, commandBufferInfoCount, VkCommandBufferSubmitInfo.SIZEOF, VkCommandBufferSubmitInfo::validate);
        }
        if (VkSubmitInfo2.nsignalSemaphoreInfoCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHOREINFOS));
        }
    }

    static {
        Struct.Layout layout = VkSubmitInfo2.__struct(VkSubmitInfo2.__member(4), VkSubmitInfo2.__member(POINTER_SIZE), VkSubmitInfo2.__member(4), VkSubmitInfo2.__member(4), VkSubmitInfo2.__member(POINTER_SIZE), VkSubmitInfo2.__member(4), VkSubmitInfo2.__member(POINTER_SIZE), VkSubmitInfo2.__member(4), VkSubmitInfo2.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        WAITSEMAPHOREINFOCOUNT = layout.offsetof(3);
        PWAITSEMAPHOREINFOS = layout.offsetof(4);
        COMMANDBUFFERINFOCOUNT = layout.offsetof(5);
        PCOMMANDBUFFERINFOS = layout.offsetof(6);
        SIGNALSEMAPHOREINFOCOUNT = layout.offsetof(7);
        PSIGNALSEMAPHOREINFOS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkSubmitInfo2, Buffer>
    implements NativeResource {
        private static final VkSubmitInfo2 ELEMENT_FACTORY = VkSubmitInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubmitInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubmitInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubmitInfo2.npNext(this.address());
        }

        @NativeType(value="VkSubmitFlags")
        public int flags() {
            return VkSubmitInfo2.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreInfoCount() {
            return VkSubmitInfo2.nwaitSemaphoreInfoCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphoreSubmitInfo const *")
        public VkSemaphoreSubmitInfo.Buffer pWaitSemaphoreInfos() {
            return VkSubmitInfo2.npWaitSemaphoreInfos(this.address());
        }

        @NativeType(value="uint32_t")
        public int commandBufferInfoCount() {
            return VkSubmitInfo2.ncommandBufferInfoCount(this.address());
        }

        @Nullable
        @NativeType(value="VkCommandBufferSubmitInfo const *")
        public VkCommandBufferSubmitInfo.Buffer pCommandBufferInfos() {
            return VkSubmitInfo2.npCommandBufferInfos(this.address());
        }

        @NativeType(value="uint32_t")
        public int signalSemaphoreInfoCount() {
            return VkSubmitInfo2.nsignalSemaphoreInfoCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphoreSubmitInfo const *")
        public VkSemaphoreSubmitInfo.Buffer pSignalSemaphoreInfos() {
            return VkSubmitInfo2.npSignalSemaphoreInfos(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubmitInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubmitInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkFrameBoundaryEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPerformanceQuerySubmitInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWin32KeyedMutexAcquireReleaseInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWin32KeyedMutexAcquireReleaseInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkSubmitFlags") int value) {
            VkSubmitInfo2.nflags(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphoreInfos(@Nullable @NativeType(value="VkSemaphoreSubmitInfo const *") VkSemaphoreSubmitInfo.Buffer value) {
            VkSubmitInfo2.npWaitSemaphoreInfos(this.address(), value);
            return this;
        }

        public Buffer pCommandBufferInfos(@Nullable @NativeType(value="VkCommandBufferSubmitInfo const *") VkCommandBufferSubmitInfo.Buffer value) {
            VkSubmitInfo2.npCommandBufferInfos(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphoreInfos(@Nullable @NativeType(value="VkSemaphoreSubmitInfo const *") VkSemaphoreSubmitInfo.Buffer value) {
            VkSubmitInfo2.npSignalSemaphoreInfos(this.address(), value);
            return this;
        }
    }
}

