/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkStencilOpState
extends Struct<VkStencilOpState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FAILOP;
    public static final int PASSOP;
    public static final int DEPTHFAILOP;
    public static final int COMPAREOP;
    public static final int COMPAREMASK;
    public static final int WRITEMASK;
    public static final int REFERENCE;

    protected VkStencilOpState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkStencilOpState create(long address, @Nullable ByteBuffer container) {
        return new VkStencilOpState(address, container);
    }

    public VkStencilOpState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkStencilOpState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStencilOp")
    public int failOp() {
        return VkStencilOpState.nfailOp(this.address());
    }

    @NativeType(value="VkStencilOp")
    public int passOp() {
        return VkStencilOpState.npassOp(this.address());
    }

    @NativeType(value="VkStencilOp")
    public int depthFailOp() {
        return VkStencilOpState.ndepthFailOp(this.address());
    }

    @NativeType(value="VkCompareOp")
    public int compareOp() {
        return VkStencilOpState.ncompareOp(this.address());
    }

    @NativeType(value="uint32_t")
    public int compareMask() {
        return VkStencilOpState.ncompareMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int writeMask() {
        return VkStencilOpState.nwriteMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int reference() {
        return VkStencilOpState.nreference(this.address());
    }

    public VkStencilOpState failOp(@NativeType(value="VkStencilOp") int value) {
        VkStencilOpState.nfailOp(this.address(), value);
        return this;
    }

    public VkStencilOpState passOp(@NativeType(value="VkStencilOp") int value) {
        VkStencilOpState.npassOp(this.address(), value);
        return this;
    }

    public VkStencilOpState depthFailOp(@NativeType(value="VkStencilOp") int value) {
        VkStencilOpState.ndepthFailOp(this.address(), value);
        return this;
    }

    public VkStencilOpState compareOp(@NativeType(value="VkCompareOp") int value) {
        VkStencilOpState.ncompareOp(this.address(), value);
        return this;
    }

    public VkStencilOpState compareMask(@NativeType(value="uint32_t") int value) {
        VkStencilOpState.ncompareMask(this.address(), value);
        return this;
    }

    public VkStencilOpState writeMask(@NativeType(value="uint32_t") int value) {
        VkStencilOpState.nwriteMask(this.address(), value);
        return this;
    }

    public VkStencilOpState reference(@NativeType(value="uint32_t") int value) {
        VkStencilOpState.nreference(this.address(), value);
        return this;
    }

    public VkStencilOpState set(int failOp, int passOp, int depthFailOp, int compareOp, int compareMask, int writeMask, int reference) {
        this.failOp(failOp);
        this.passOp(passOp);
        this.depthFailOp(depthFailOp);
        this.compareOp(compareOp);
        this.compareMask(compareMask);
        this.writeMask(writeMask);
        this.reference(reference);
        return this;
    }

    public VkStencilOpState set(VkStencilOpState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkStencilOpState malloc() {
        return new VkStencilOpState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkStencilOpState calloc() {
        return new VkStencilOpState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkStencilOpState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkStencilOpState(MemoryUtil.memAddress(container), container);
    }

    public static VkStencilOpState create(long address) {
        return new VkStencilOpState(address, null);
    }

    @Nullable
    public static VkStencilOpState createSafe(long address) {
        return address == 0L ? null : new VkStencilOpState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkStencilOpState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkStencilOpState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkStencilOpState mallocStack() {
        return VkStencilOpState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkStencilOpState callocStack() {
        return VkStencilOpState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkStencilOpState mallocStack(MemoryStack stack) {
        return VkStencilOpState.malloc(stack);
    }

    @Deprecated
    public static VkStencilOpState callocStack(MemoryStack stack) {
        return VkStencilOpState.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkStencilOpState.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkStencilOpState.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkStencilOpState.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkStencilOpState.calloc(capacity, stack);
    }

    public static VkStencilOpState malloc(MemoryStack stack) {
        return new VkStencilOpState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkStencilOpState calloc(MemoryStack stack) {
        return new VkStencilOpState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nfailOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)FAILOP);
    }

    public static int npassOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)PASSOP);
    }

    public static int ndepthFailOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHFAILOP);
    }

    public static int ncompareOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPAREOP);
    }

    public static int ncompareMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPAREMASK);
    }

    public static int nwriteMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)WRITEMASK);
    }

    public static int nreference(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCE);
    }

    public static void nfailOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FAILOP, value);
    }

    public static void npassOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PASSOP, value);
    }

    public static void ndepthFailOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHFAILOP, value);
    }

    public static void ncompareOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPAREOP, value);
    }

    public static void ncompareMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPAREMASK, value);
    }

    public static void nwriteMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WRITEMASK, value);
    }

    public static void nreference(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCE, value);
    }

    static {
        Struct.Layout layout = VkStencilOpState.__struct(VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4), VkStencilOpState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FAILOP = layout.offsetof(0);
        PASSOP = layout.offsetof(1);
        DEPTHFAILOP = layout.offsetof(2);
        COMPAREOP = layout.offsetof(3);
        COMPAREMASK = layout.offsetof(4);
        WRITEMASK = layout.offsetof(5);
        REFERENCE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkStencilOpState, Buffer>
    implements NativeResource {
        private static final VkStencilOpState ELEMENT_FACTORY = VkStencilOpState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkStencilOpState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStencilOp")
        public int failOp() {
            return VkStencilOpState.nfailOp(this.address());
        }

        @NativeType(value="VkStencilOp")
        public int passOp() {
            return VkStencilOpState.npassOp(this.address());
        }

        @NativeType(value="VkStencilOp")
        public int depthFailOp() {
            return VkStencilOpState.ndepthFailOp(this.address());
        }

        @NativeType(value="VkCompareOp")
        public int compareOp() {
            return VkStencilOpState.ncompareOp(this.address());
        }

        @NativeType(value="uint32_t")
        public int compareMask() {
            return VkStencilOpState.ncompareMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int writeMask() {
            return VkStencilOpState.nwriteMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int reference() {
            return VkStencilOpState.nreference(this.address());
        }

        public Buffer failOp(@NativeType(value="VkStencilOp") int value) {
            VkStencilOpState.nfailOp(this.address(), value);
            return this;
        }

        public Buffer passOp(@NativeType(value="VkStencilOp") int value) {
            VkStencilOpState.npassOp(this.address(), value);
            return this;
        }

        public Buffer depthFailOp(@NativeType(value="VkStencilOp") int value) {
            VkStencilOpState.ndepthFailOp(this.address(), value);
            return this;
        }

        public Buffer compareOp(@NativeType(value="VkCompareOp") int value) {
            VkStencilOpState.ncompareOp(this.address(), value);
            return this;
        }

        public Buffer compareMask(@NativeType(value="uint32_t") int value) {
            VkStencilOpState.ncompareMask(this.address(), value);
            return this;
        }

        public Buffer writeMask(@NativeType(value="uint32_t") int value) {
            VkStencilOpState.nwriteMask(this.address(), value);
            return this;
        }

        public Buffer reference(@NativeType(value="uint32_t") int value) {
            VkStencilOpState.nreference(this.address(), value);
            return this;
        }
    }
}

