/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkSparseImageFormatProperties
extends Struct<VkSparseImageFormatProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int IMAGEGRANULARITY;
    public static final int FLAGS;

    protected VkSparseImageFormatProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSparseImageFormatProperties create(long address, @Nullable ByteBuffer container) {
        return new VkSparseImageFormatProperties(address, container);
    }

    public VkSparseImageFormatProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSparseImageFormatProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkSparseImageFormatProperties.naspectMask(this.address());
    }

    public VkExtent3D imageGranularity() {
        return VkSparseImageFormatProperties.nimageGranularity(this.address());
    }

    @NativeType(value="VkSparseImageFormatFlags")
    public int flags() {
        return VkSparseImageFormatProperties.nflags(this.address());
    }

    public static VkSparseImageFormatProperties malloc() {
        return new VkSparseImageFormatProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSparseImageFormatProperties calloc() {
        return new VkSparseImageFormatProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSparseImageFormatProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSparseImageFormatProperties(MemoryUtil.memAddress(container), container);
    }

    public static VkSparseImageFormatProperties create(long address) {
        return new VkSparseImageFormatProperties(address, null);
    }

    @Nullable
    public static VkSparseImageFormatProperties createSafe(long address) {
        return address == 0L ? null : new VkSparseImageFormatProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSparseImageFormatProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageFormatProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSparseImageFormatProperties mallocStack() {
        return VkSparseImageFormatProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageFormatProperties callocStack() {
        return VkSparseImageFormatProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageFormatProperties mallocStack(MemoryStack stack) {
        return VkSparseImageFormatProperties.malloc(stack);
    }

    @Deprecated
    public static VkSparseImageFormatProperties callocStack(MemoryStack stack) {
        return VkSparseImageFormatProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseImageFormatProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseImageFormatProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageFormatProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageFormatProperties.calloc(capacity, stack);
    }

    public static VkSparseImageFormatProperties malloc(MemoryStack stack) {
        return new VkSparseImageFormatProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSparseImageFormatProperties calloc(MemoryStack stack) {
        return new VkSparseImageFormatProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static VkExtent3D nimageGranularity(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEGRANULARITY);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkSparseImageFormatProperties.__struct(VkSparseImageFormatProperties.__member(4), VkSparseImageFormatProperties.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkSparseImageFormatProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        IMAGEGRANULARITY = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageFormatProperties, Buffer>
    implements NativeResource {
        private static final VkSparseImageFormatProperties ELEMENT_FACTORY = VkSparseImageFormatProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSparseImageFormatProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkSparseImageFormatProperties.naspectMask(this.address());
        }

        public VkExtent3D imageGranularity() {
            return VkSparseImageFormatProperties.nimageGranularity(this.address());
        }

        @NativeType(value="VkSparseImageFormatFlags")
        public int flags() {
            return VkSparseImageFormatProperties.nflags(this.address());
        }
    }
}

