/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceGroupPresentInfoKHR;
import org.lwjgl.vulkan.VkDisplayPresentInfoKHR;
import org.lwjgl.vulkan.VkFrameBoundaryEXT;
import org.lwjgl.vulkan.VkPresentIdKHR;
import org.lwjgl.vulkan.VkPresentRegionsKHR;
import org.lwjgl.vulkan.VkPresentTimesInfoGOOGLE;
import org.lwjgl.vulkan.VkSwapchainPresentFenceInfoEXT;
import org.lwjgl.vulkan.VkSwapchainPresentModeInfoEXT;

public class VkPresentInfoKHR
extends Struct<VkPresentInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int SWAPCHAINCOUNT;
    public static final int PSWAPCHAINS;
    public static final int PIMAGEINDICES;
    public static final int PRESULTS;

    protected VkPresentInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPresentInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPresentInfoKHR(address, container);
    }

    public VkPresentInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPresentInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPresentInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPresentInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkPresentInfoKHR.nwaitSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pWaitSemaphores() {
        return VkPresentInfoKHR.npWaitSemaphores(this.address());
    }

    @NativeType(value="uint32_t")
    public int swapchainCount() {
        return VkPresentInfoKHR.nswapchainCount(this.address());
    }

    @NativeType(value="VkSwapchainKHR const *")
    public LongBuffer pSwapchains() {
        return VkPresentInfoKHR.npSwapchains(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pImageIndices() {
        return VkPresentInfoKHR.npImageIndices(this.address());
    }

    @Nullable
    @NativeType(value="VkResult *")
    public IntBuffer pResults() {
        return VkPresentInfoKHR.npResults(this.address());
    }

    public VkPresentInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR sType$Default() {
        return this.sType(1000001001);
    }

    public VkPresentInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pNext(VkDeviceGroupPresentInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkDisplayPresentInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkFrameBoundaryEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkPresentIdKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkPresentRegionsKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkPresentTimesInfoGOOGLE value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkSwapchainPresentFenceInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pNext(VkSwapchainPresentModeInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPresentInfoKHR pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkPresentInfoKHR.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR swapchainCount(@NativeType(value="uint32_t") int value) {
        VkPresentInfoKHR.nswapchainCount(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pSwapchains(@NativeType(value="VkSwapchainKHR const *") LongBuffer value) {
        VkPresentInfoKHR.npSwapchains(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pImageIndices(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkPresentInfoKHR.npImageIndices(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pResults(@Nullable @NativeType(value="VkResult *") IntBuffer value) {
        VkPresentInfoKHR.npResults(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR set(int sType, long pNext, @Nullable LongBuffer pWaitSemaphores, int swapchainCount, LongBuffer pSwapchains, IntBuffer pImageIndices, @Nullable IntBuffer pResults) {
        this.sType(sType);
        this.pNext(pNext);
        this.pWaitSemaphores(pWaitSemaphores);
        this.swapchainCount(swapchainCount);
        this.pSwapchains(pSwapchains);
        this.pImageIndices(pImageIndices);
        this.pResults(pResults);
        return this;
    }

    public VkPresentInfoKHR set(VkPresentInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPresentInfoKHR malloc() {
        return new VkPresentInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPresentInfoKHR calloc() {
        return new VkPresentInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPresentInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPresentInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPresentInfoKHR create(long address) {
        return new VkPresentInfoKHR(address, null);
    }

    @Nullable
    public static VkPresentInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPresentInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPresentInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPresentInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPresentInfoKHR mallocStack() {
        return VkPresentInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPresentInfoKHR callocStack() {
        return VkPresentInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPresentInfoKHR mallocStack(MemoryStack stack) {
        return VkPresentInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkPresentInfoKHR callocStack(MemoryStack stack) {
        return VkPresentInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPresentInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPresentInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPresentInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPresentInfoKHR.calloc(capacity, stack);
    }

    public static VkPresentInfoKHR malloc(MemoryStack stack) {
        return new VkPresentInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPresentInfoKHR calloc(MemoryStack stack) {
        return new VkPresentInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nwaitSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WAITSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES), VkPresentInfoKHR.nwaitSemaphoreCount(struct));
    }

    public static int nswapchainCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SWAPCHAINCOUNT);
    }

    public static LongBuffer npSwapchains(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PSWAPCHAINS), VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static IntBuffer npImageIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PIMAGEINDICES), VkPresentInfoKHR.nswapchainCount(struct));
    }

    @Nullable
    public static IntBuffer npResults(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PRESULTS), VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHORES, MemoryUtil.memAddressSafe(value));
        VkPresentInfoKHR.nwaitSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nswapchainCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SWAPCHAINCOUNT, value);
    }

    public static void npSwapchains(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSWAPCHAINS, MemoryUtil.memAddress(value));
    }

    public static void npImageIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMAGEINDICES, MemoryUtil.memAddress(value));
    }

    public static void npResults(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESULTS, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        if (VkPresentInfoKHR.nwaitSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES));
        }
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSWAPCHAINS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PIMAGEINDICES));
    }

    static {
        Struct.Layout layout = VkPresentInfoKHR.__struct(VkPresentInfoKHR.__member(4), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(4), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(4), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(POINTER_SIZE), VkPresentInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        SWAPCHAINCOUNT = layout.offsetof(4);
        PSWAPCHAINS = layout.offsetof(5);
        PIMAGEINDICES = layout.offsetof(6);
        PRESULTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPresentInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPresentInfoKHR ELEMENT_FACTORY = VkPresentInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPresentInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPresentInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPresentInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkPresentInfoKHR.nwaitSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pWaitSemaphores() {
            return VkPresentInfoKHR.npWaitSemaphores(this.address());
        }

        @NativeType(value="uint32_t")
        public int swapchainCount() {
            return VkPresentInfoKHR.nswapchainCount(this.address());
        }

        @NativeType(value="VkSwapchainKHR const *")
        public LongBuffer pSwapchains() {
            return VkPresentInfoKHR.npSwapchains(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pImageIndices() {
            return VkPresentInfoKHR.npImageIndices(this.address());
        }

        @Nullable
        @NativeType(value="VkResult *")
        public IntBuffer pResults() {
            return VkPresentInfoKHR.npResults(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000001001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceGroupPresentInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDisplayPresentInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkFrameBoundaryEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPresentIdKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPresentRegionsKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPresentTimesInfoGOOGLE value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainPresentFenceInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainPresentModeInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkPresentInfoKHR.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer swapchainCount(@NativeType(value="uint32_t") int value) {
            VkPresentInfoKHR.nswapchainCount(this.address(), value);
            return this;
        }

        public Buffer pSwapchains(@NativeType(value="VkSwapchainKHR const *") LongBuffer value) {
            VkPresentInfoKHR.npSwapchains(this.address(), value);
            return this;
        }

        public Buffer pImageIndices(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkPresentInfoKHR.npImageIndices(this.address(), value);
            return this;
        }

        public Buffer pResults(@Nullable @NativeType(value="VkResult *") IntBuffer value) {
            VkPresentInfoKHR.npResults(this.address(), value);
            return this;
        }
    }
}

