/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDebugUtilsObjectNameInfoEXT;
import org.lwjgl.vulkan.VkPipelineRobustnessCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineShaderStageModuleIdentifierCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineShaderStageNodeCreateInfoAMDX;
import org.lwjgl.vulkan.VkPipelineShaderStageRequiredSubgroupSizeCreateInfo;
import org.lwjgl.vulkan.VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT;
import org.lwjgl.vulkan.VkShaderModuleCreateInfo;
import org.lwjgl.vulkan.VkShaderModuleValidationCacheCreateInfoEXT;
import org.lwjgl.vulkan.VkShaderRequiredSubgroupSizeCreateInfoEXT;
import org.lwjgl.vulkan.VkSpecializationInfo;

public class VkPipelineShaderStageCreateInfo
extends Struct<VkPipelineShaderStageCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGE;
    public static final int MODULE;
    public static final int PNAME;
    public static final int PSPECIALIZATIONINFO;

    protected VkPipelineShaderStageCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineShaderStageCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineShaderStageCreateInfo(address, container);
    }

    public VkPipelineShaderStageCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineShaderStageCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineShaderStageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineShaderStageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineShaderStageCreateFlags")
    public int flags() {
        return VkPipelineShaderStageCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkShaderStageFlagBits")
    public int stage() {
        return VkPipelineShaderStageCreateInfo.nstage(this.address());
    }

    @NativeType(value="VkShaderModule")
    public long module() {
        return VkPipelineShaderStageCreateInfo.nmodule(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pName() {
        return VkPipelineShaderStageCreateInfo.npName(this.address());
    }

    @NativeType(value="char const *")
    public String pNameString() {
        return VkPipelineShaderStageCreateInfo.npNameString(this.address());
    }

    @Nullable
    @NativeType(value="VkSpecializationInfo const *")
    public VkSpecializationInfo pSpecializationInfo() {
        return VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address());
    }

    public VkPipelineShaderStageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineShaderStageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo sType$Default() {
        return this.sType(18);
    }

    public VkPipelineShaderStageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineShaderStageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pNext(VkDebugUtilsObjectNameInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkPipelineRobustnessCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkPipelineShaderStageModuleIdentifierCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkPipelineShaderStageNodeCreateInfoAMDX value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkShaderModuleCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkShaderModuleValidationCacheCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo pNext(VkShaderRequiredSubgroupSizeCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineShaderStageCreateInfo flags(@NativeType(value="VkPipelineShaderStageCreateFlags") int value) {
        VkPipelineShaderStageCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo stage(@NativeType(value="VkShaderStageFlagBits") int value) {
        VkPipelineShaderStageCreateInfo.nstage(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo module(@NativeType(value="VkShaderModule") long value) {
        VkPipelineShaderStageCreateInfo.nmodule(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pName(@NativeType(value="char const *") ByteBuffer value) {
        VkPipelineShaderStageCreateInfo.npName(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pSpecializationInfo(@Nullable @NativeType(value="VkSpecializationInfo const *") VkSpecializationInfo value) {
        VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo set(int sType, long pNext, int flags, int stage, long module, ByteBuffer pName, @Nullable VkSpecializationInfo pSpecializationInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stage(stage);
        this.module(module);
        this.pName(pName);
        this.pSpecializationInfo(pSpecializationInfo);
        return this;
    }

    public VkPipelineShaderStageCreateInfo set(VkPipelineShaderStageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineShaderStageCreateInfo malloc() {
        return new VkPipelineShaderStageCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineShaderStageCreateInfo calloc() {
        return new VkPipelineShaderStageCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineShaderStageCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineShaderStageCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineShaderStageCreateInfo create(long address) {
        return new VkPipelineShaderStageCreateInfo(address, null);
    }

    @Nullable
    public static VkPipelineShaderStageCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineShaderStageCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineShaderStageCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineShaderStageCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineShaderStageCreateInfo mallocStack() {
        return VkPipelineShaderStageCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineShaderStageCreateInfo callocStack() {
        return VkPipelineShaderStageCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineShaderStageCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineShaderStageCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineShaderStageCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineShaderStageCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineShaderStageCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineShaderStageCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineShaderStageCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineShaderStageCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineShaderStageCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nstage(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGE);
    }

    public static long nmodule(long struct) {
        return UNSAFE.getLong(null, struct + (long)MODULE);
    }

    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    @Nullable
    public static VkSpecializationInfo npSpecializationInfo(long struct) {
        return VkSpecializationInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PSPECIALIZATIONINFO));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nstage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGE, value);
    }

    public static void nmodule(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MODULE, value);
    }

    public static void npName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PNAME, MemoryUtil.memAddress(value));
    }

    public static void npSpecializationInfo(long struct, @Nullable VkSpecializationInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PSPECIALIZATIONINFO, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PNAME));
        long pSpecializationInfo = MemoryUtil.memGetAddress(struct + (long)PSPECIALIZATIONINFO);
        if (pSpecializationInfo != 0L) {
            VkSpecializationInfo.validate(pSpecializationInfo);
        }
    }

    static {
        Struct.Layout layout = VkPipelineShaderStageCreateInfo.__struct(VkPipelineShaderStageCreateInfo.__member(4), VkPipelineShaderStageCreateInfo.__member(POINTER_SIZE), VkPipelineShaderStageCreateInfo.__member(4), VkPipelineShaderStageCreateInfo.__member(4), VkPipelineShaderStageCreateInfo.__member(8), VkPipelineShaderStageCreateInfo.__member(POINTER_SIZE), VkPipelineShaderStageCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGE = layout.offsetof(3);
        MODULE = layout.offsetof(4);
        PNAME = layout.offsetof(5);
        PSPECIALIZATIONINFO = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineShaderStageCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineShaderStageCreateInfo ELEMENT_FACTORY = VkPipelineShaderStageCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineShaderStageCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineShaderStageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineShaderStageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineShaderStageCreateFlags")
        public int flags() {
            return VkPipelineShaderStageCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkShaderStageFlagBits")
        public int stage() {
            return VkPipelineShaderStageCreateInfo.nstage(this.address());
        }

        @NativeType(value="VkShaderModule")
        public long module() {
            return VkPipelineShaderStageCreateInfo.nmodule(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pName() {
            return VkPipelineShaderStageCreateInfo.npName(this.address());
        }

        @NativeType(value="char const *")
        public String pNameString() {
            return VkPipelineShaderStageCreateInfo.npNameString(this.address());
        }

        @Nullable
        @NativeType(value="VkSpecializationInfo const *")
        public VkSpecializationInfo pSpecializationInfo() {
            return VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineShaderStageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(18);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineShaderStageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDebugUtilsObjectNameInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRobustnessCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineShaderStageModuleIdentifierCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineShaderStageNodeCreateInfoAMDX value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkShaderModuleCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkShaderModuleValidationCacheCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkShaderRequiredSubgroupSizeCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineShaderStageCreateFlags") int value) {
            VkPipelineShaderStageCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer stage(@NativeType(value="VkShaderStageFlagBits") int value) {
            VkPipelineShaderStageCreateInfo.nstage(this.address(), value);
            return this;
        }

        public Buffer module(@NativeType(value="VkShaderModule") long value) {
            VkPipelineShaderStageCreateInfo.nmodule(this.address(), value);
            return this;
        }

        public Buffer pName(@NativeType(value="char const *") ByteBuffer value) {
            VkPipelineShaderStageCreateInfo.npName(this.address(), value);
            return this;
        }

        public Buffer pSpecializationInfo(@Nullable @NativeType(value="VkSpecializationInfo const *") VkSpecializationInfo value) {
            VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address(), value);
            return this;
        }
    }
}

