/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceSubgroupProperties
extends Struct<VkPhysicalDeviceSubgroupProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBGROUPSIZE;
    public static final int SUPPORTEDSTAGES;
    public static final int SUPPORTEDOPERATIONS;
    public static final int QUADOPERATIONSINALLSTAGES;

    protected VkPhysicalDeviceSubgroupProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceSubgroupProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceSubgroupProperties(address, container);
    }

    public VkPhysicalDeviceSubgroupProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceSubgroupProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceSubgroupProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceSubgroupProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int subgroupSize() {
        return VkPhysicalDeviceSubgroupProperties.nsubgroupSize(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int supportedStages() {
        return VkPhysicalDeviceSubgroupProperties.nsupportedStages(this.address());
    }

    @NativeType(value="VkSubgroupFeatureFlags")
    public int supportedOperations() {
        return VkPhysicalDeviceSubgroupProperties.nsupportedOperations(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean quadOperationsInAllStages() {
        return VkPhysicalDeviceSubgroupProperties.nquadOperationsInAllStages(this.address()) != 0;
    }

    public VkPhysicalDeviceSubgroupProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceSubgroupProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties sType$Default() {
        return this.sType(1000094000);
    }

    public VkPhysicalDeviceSubgroupProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceSubgroupProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties set(VkPhysicalDeviceSubgroupProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceSubgroupProperties malloc() {
        return new VkPhysicalDeviceSubgroupProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceSubgroupProperties calloc() {
        return new VkPhysicalDeviceSubgroupProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceSubgroupProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceSubgroupProperties(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceSubgroupProperties create(long address) {
        return new VkPhysicalDeviceSubgroupProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceSubgroupProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceSubgroupProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceSubgroupProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceSubgroupProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceSubgroupProperties mallocStack() {
        return VkPhysicalDeviceSubgroupProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceSubgroupProperties callocStack() {
        return VkPhysicalDeviceSubgroupProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceSubgroupProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceSubgroupProperties.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceSubgroupProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceSubgroupProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceSubgroupProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceSubgroupProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceSubgroupProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceSubgroupProperties.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceSubgroupProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceSubgroupProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceSubgroupProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceSubgroupProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsubgroupSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBGROUPSIZE);
    }

    public static int nsupportedStages(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDSTAGES);
    }

    public static int nsupportedOperations(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDOPERATIONS);
    }

    public static int nquadOperationsInAllStages(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUADOPERATIONSINALLSTAGES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceSubgroupProperties.__struct(VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(POINTER_SIZE), VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBGROUPSIZE = layout.offsetof(2);
        SUPPORTEDSTAGES = layout.offsetof(3);
        SUPPORTEDOPERATIONS = layout.offsetof(4);
        QUADOPERATIONSINALLSTAGES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceSubgroupProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceSubgroupProperties ELEMENT_FACTORY = VkPhysicalDeviceSubgroupProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceSubgroupProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceSubgroupProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceSubgroupProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int subgroupSize() {
            return VkPhysicalDeviceSubgroupProperties.nsubgroupSize(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int supportedStages() {
            return VkPhysicalDeviceSubgroupProperties.nsupportedStages(this.address());
        }

        @NativeType(value="VkSubgroupFeatureFlags")
        public int supportedOperations() {
            return VkPhysicalDeviceSubgroupProperties.nsupportedOperations(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean quadOperationsInAllStages() {
            return VkPhysicalDeviceSubgroupProperties.nquadOperationsInAllStages(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceSubgroupProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000094000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceSubgroupProperties.npNext(this.address(), value);
            return this;
        }
    }
}

