/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceProtectedMemoryProperties
extends Struct<VkPhysicalDeviceProtectedMemoryProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROTECTEDNOFAULT;

    protected VkPhysicalDeviceProtectedMemoryProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceProtectedMemoryProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceProtectedMemoryProperties(address, container);
    }

    public VkPhysicalDeviceProtectedMemoryProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceProtectedMemoryProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean protectedNoFault() {
        return VkPhysicalDeviceProtectedMemoryProperties.nprotectedNoFault(this.address()) != 0;
    }

    public VkPhysicalDeviceProtectedMemoryProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties sType$Default() {
        return this.sType(1000145002);
    }

    public VkPhysicalDeviceProtectedMemoryProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryProperties set(VkPhysicalDeviceProtectedMemoryProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProtectedMemoryProperties malloc() {
        return new VkPhysicalDeviceProtectedMemoryProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceProtectedMemoryProperties calloc() {
        return new VkPhysicalDeviceProtectedMemoryProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceProtectedMemoryProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceProtectedMemoryProperties(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceProtectedMemoryProperties create(long address) {
        return new VkPhysicalDeviceProtectedMemoryProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceProtectedMemoryProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceProtectedMemoryProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceProtectedMemoryProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceProtectedMemoryProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryProperties mallocStack() {
        return VkPhysicalDeviceProtectedMemoryProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryProperties callocStack() {
        return VkPhysicalDeviceProtectedMemoryProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryProperties.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceProtectedMemoryProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceProtectedMemoryProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceProtectedMemoryProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceProtectedMemoryProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprotectedNoFault(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROTECTEDNOFAULT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProtectedMemoryProperties.__struct(VkPhysicalDeviceProtectedMemoryProperties.__member(4), VkPhysicalDeviceProtectedMemoryProperties.__member(POINTER_SIZE), VkPhysicalDeviceProtectedMemoryProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROTECTEDNOFAULT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProtectedMemoryProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceProtectedMemoryProperties ELEMENT_FACTORY = VkPhysicalDeviceProtectedMemoryProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceProtectedMemoryProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean protectedNoFault() {
            return VkPhysicalDeviceProtectedMemoryProperties.nprotectedNoFault(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProtectedMemoryProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000145002);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProtectedMemoryProperties.npNext(this.address(), value);
            return this;
        }
    }
}

