/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMutableDescriptorTypeListEXT;

public class VkMutableDescriptorTypeCreateInfoEXT
extends Struct<VkMutableDescriptorTypeCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MUTABLEDESCRIPTORTYPELISTCOUNT;
    public static final int PMUTABLEDESCRIPTORTYPELISTS;

    protected VkMutableDescriptorTypeCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMutableDescriptorTypeCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMutableDescriptorTypeCreateInfoEXT(address, container);
    }

    public VkMutableDescriptorTypeCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMutableDescriptorTypeCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMutableDescriptorTypeCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMutableDescriptorTypeCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int mutableDescriptorTypeListCount() {
        return VkMutableDescriptorTypeCreateInfoEXT.nmutableDescriptorTypeListCount(this.address());
    }

    @Nullable
    @NativeType(value="VkMutableDescriptorTypeListEXT const *")
    public VkMutableDescriptorTypeListEXT.Buffer pMutableDescriptorTypeLists() {
        return VkMutableDescriptorTypeCreateInfoEXT.npMutableDescriptorTypeLists(this.address());
    }

    public VkMutableDescriptorTypeCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMutableDescriptorTypeCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMutableDescriptorTypeCreateInfoEXT sType$Default() {
        return this.sType(1000351002);
    }

    public VkMutableDescriptorTypeCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMutableDescriptorTypeCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMutableDescriptorTypeCreateInfoEXT pMutableDescriptorTypeLists(@Nullable @NativeType(value="VkMutableDescriptorTypeListEXT const *") VkMutableDescriptorTypeListEXT.Buffer value) {
        VkMutableDescriptorTypeCreateInfoEXT.npMutableDescriptorTypeLists(this.address(), value);
        return this;
    }

    public VkMutableDescriptorTypeCreateInfoEXT set(int sType, long pNext, @Nullable VkMutableDescriptorTypeListEXT.Buffer pMutableDescriptorTypeLists) {
        this.sType(sType);
        this.pNext(pNext);
        this.pMutableDescriptorTypeLists(pMutableDescriptorTypeLists);
        return this;
    }

    public VkMutableDescriptorTypeCreateInfoEXT set(VkMutableDescriptorTypeCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMutableDescriptorTypeCreateInfoEXT malloc() {
        return new VkMutableDescriptorTypeCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMutableDescriptorTypeCreateInfoEXT calloc() {
        return new VkMutableDescriptorTypeCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMutableDescriptorTypeCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMutableDescriptorTypeCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMutableDescriptorTypeCreateInfoEXT create(long address) {
        return new VkMutableDescriptorTypeCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkMutableDescriptorTypeCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMutableDescriptorTypeCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMutableDescriptorTypeCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMutableDescriptorTypeCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMutableDescriptorTypeCreateInfoEXT malloc(MemoryStack stack) {
        return new VkMutableDescriptorTypeCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMutableDescriptorTypeCreateInfoEXT calloc(MemoryStack stack) {
        return new VkMutableDescriptorTypeCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmutableDescriptorTypeListCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MUTABLEDESCRIPTORTYPELISTCOUNT);
    }

    @Nullable
    public static VkMutableDescriptorTypeListEXT.Buffer npMutableDescriptorTypeLists(long struct) {
        return VkMutableDescriptorTypeListEXT.createSafe(MemoryUtil.memGetAddress(struct + (long)PMUTABLEDESCRIPTORTYPELISTS), VkMutableDescriptorTypeCreateInfoEXT.nmutableDescriptorTypeListCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmutableDescriptorTypeListCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MUTABLEDESCRIPTORTYPELISTCOUNT, value);
    }

    public static void npMutableDescriptorTypeLists(long struct, @Nullable VkMutableDescriptorTypeListEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PMUTABLEDESCRIPTORTYPELISTS, MemoryUtil.memAddressSafe(value));
        VkMutableDescriptorTypeCreateInfoEXT.nmutableDescriptorTypeListCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int mutableDescriptorTypeListCount = VkMutableDescriptorTypeCreateInfoEXT.nmutableDescriptorTypeListCount(struct);
        if (mutableDescriptorTypeListCount != 0) {
            long pMutableDescriptorTypeLists = MemoryUtil.memGetAddress(struct + (long)PMUTABLEDESCRIPTORTYPELISTS);
            Checks.check(pMutableDescriptorTypeLists);
            VkMutableDescriptorTypeCreateInfoEXT.validate(pMutableDescriptorTypeLists, mutableDescriptorTypeListCount, VkMutableDescriptorTypeListEXT.SIZEOF, VkMutableDescriptorTypeListEXT::validate);
        }
    }

    static {
        Struct.Layout layout = VkMutableDescriptorTypeCreateInfoEXT.__struct(VkMutableDescriptorTypeCreateInfoEXT.__member(4), VkMutableDescriptorTypeCreateInfoEXT.__member(POINTER_SIZE), VkMutableDescriptorTypeCreateInfoEXT.__member(4), VkMutableDescriptorTypeCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MUTABLEDESCRIPTORTYPELISTCOUNT = layout.offsetof(2);
        PMUTABLEDESCRIPTORTYPELISTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMutableDescriptorTypeCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMutableDescriptorTypeCreateInfoEXT ELEMENT_FACTORY = VkMutableDescriptorTypeCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMutableDescriptorTypeCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMutableDescriptorTypeCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMutableDescriptorTypeCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int mutableDescriptorTypeListCount() {
            return VkMutableDescriptorTypeCreateInfoEXT.nmutableDescriptorTypeListCount(this.address());
        }

        @Nullable
        @NativeType(value="VkMutableDescriptorTypeListEXT const *")
        public VkMutableDescriptorTypeListEXT.Buffer pMutableDescriptorTypeLists() {
            return VkMutableDescriptorTypeCreateInfoEXT.npMutableDescriptorTypeLists(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMutableDescriptorTypeCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000351002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMutableDescriptorTypeCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pMutableDescriptorTypeLists(@Nullable @NativeType(value="VkMutableDescriptorTypeListEXT const *") VkMutableDescriptorTypeListEXT.Buffer value) {
            VkMutableDescriptorTypeCreateInfoEXT.npMutableDescriptorTypeLists(this.address(), value);
            return this;
        }
    }
}

