/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryUnmapInfoKHR
extends Struct<VkMemoryUnmapInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MEMORY;

    protected VkMemoryUnmapInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryUnmapInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryUnmapInfoKHR(address, container);
    }

    public VkMemoryUnmapInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryUnmapInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryUnmapInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryUnmapInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkMemoryUnmapFlagsKHR")
    public int flags() {
        return VkMemoryUnmapInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryUnmapInfoKHR.nmemory(this.address());
    }

    public VkMemoryUnmapInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryUnmapInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfoKHR sType$Default() {
        return this.sType(1000271001);
    }

    public VkMemoryUnmapInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryUnmapInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfoKHR flags(@NativeType(value="VkMemoryUnmapFlagsKHR") int value) {
        VkMemoryUnmapInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryUnmapInfoKHR.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfoKHR set(int sType, long pNext, int flags, long memory) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        return this;
    }

    public VkMemoryUnmapInfoKHR set(VkMemoryUnmapInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryUnmapInfoKHR malloc() {
        return new VkMemoryUnmapInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryUnmapInfoKHR calloc() {
        return new VkMemoryUnmapInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryUnmapInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryUnmapInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryUnmapInfoKHR create(long address) {
        return new VkMemoryUnmapInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryUnmapInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryUnmapInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryUnmapInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryUnmapInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryUnmapInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryUnmapInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryUnmapInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryUnmapInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    static {
        Struct.Layout layout = VkMemoryUnmapInfoKHR.__struct(VkMemoryUnmapInfoKHR.__member(4), VkMemoryUnmapInfoKHR.__member(POINTER_SIZE), VkMemoryUnmapInfoKHR.__member(4), VkMemoryUnmapInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryUnmapInfoKHR, Buffer>
    implements NativeResource {
        private static final VkMemoryUnmapInfoKHR ELEMENT_FACTORY = VkMemoryUnmapInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryUnmapInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryUnmapInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryUnmapInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkMemoryUnmapFlagsKHR")
        public int flags() {
            return VkMemoryUnmapInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryUnmapInfoKHR.nmemory(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryUnmapInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000271001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryUnmapInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMemoryUnmapFlagsKHR") int value) {
            VkMemoryUnmapInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryUnmapInfoKHR.nmemory(this.address(), value);
            return this;
        }
    }
}

