/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMetalBufferInfoEXT
extends Struct<VkImportMetalBufferInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MTLBUFFER;

    protected VkImportMetalBufferInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImportMetalBufferInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkImportMetalBufferInfoEXT(address, container);
    }

    public VkImportMetalBufferInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImportMetalBufferInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMetalBufferInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMetalBufferInfoEXT.npNext(this.address());
    }

    @NativeType(value="MTLBuffer_id")
    public long mtlBuffer() {
        return VkImportMetalBufferInfoEXT.nmtlBuffer(this.address());
    }

    public VkImportMetalBufferInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImportMetalBufferInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkImportMetalBufferInfoEXT sType$Default() {
        return this.sType(1000311005);
    }

    public VkImportMetalBufferInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkImportMetalBufferInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkImportMetalBufferInfoEXT mtlBuffer(@NativeType(value="MTLBuffer_id") long value) {
        VkImportMetalBufferInfoEXT.nmtlBuffer(this.address(), value);
        return this;
    }

    public VkImportMetalBufferInfoEXT set(int sType, long pNext, long mtlBuffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.mtlBuffer(mtlBuffer);
        return this;
    }

    public VkImportMetalBufferInfoEXT set(VkImportMetalBufferInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMetalBufferInfoEXT malloc() {
        return new VkImportMetalBufferInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImportMetalBufferInfoEXT calloc() {
        return new VkImportMetalBufferInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImportMetalBufferInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImportMetalBufferInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkImportMetalBufferInfoEXT create(long address) {
        return new VkImportMetalBufferInfoEXT(address, null);
    }

    @Nullable
    public static VkImportMetalBufferInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkImportMetalBufferInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImportMetalBufferInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMetalBufferInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImportMetalBufferInfoEXT malloc(MemoryStack stack) {
        return new VkImportMetalBufferInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImportMetalBufferInfoEXT calloc(MemoryStack stack) {
        return new VkImportMetalBufferInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmtlBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MTLBUFFER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmtlBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MTLBUFFER, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MTLBUFFER));
    }

    static {
        Struct.Layout layout = VkImportMetalBufferInfoEXT.__struct(VkImportMetalBufferInfoEXT.__member(4), VkImportMetalBufferInfoEXT.__member(POINTER_SIZE), VkImportMetalBufferInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MTLBUFFER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImportMetalBufferInfoEXT, Buffer>
    implements NativeResource {
        private static final VkImportMetalBufferInfoEXT ELEMENT_FACTORY = VkImportMetalBufferInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImportMetalBufferInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMetalBufferInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMetalBufferInfoEXT.npNext(this.address());
        }

        @NativeType(value="MTLBuffer_id")
        public long mtlBuffer() {
            return VkImportMetalBufferInfoEXT.nmtlBuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMetalBufferInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000311005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMetalBufferInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer mtlBuffer(@NativeType(value="MTLBuffer_id") long value) {
            VkImportMetalBufferInfoEXT.nmtlBuffer(this.address(), value);
            return this;
        }
    }
}

