/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageToMemoryCopyEXT
extends Struct<VkImageToMemoryCopyEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHOSTPOINTER;
    public static final int MEMORYROWLENGTH;
    public static final int MEMORYIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkImageToMemoryCopyEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageToMemoryCopyEXT create(long address, @Nullable ByteBuffer container) {
        return new VkImageToMemoryCopyEXT(address, container);
    }

    public VkImageToMemoryCopyEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageToMemoryCopyEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageToMemoryCopyEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageToMemoryCopyEXT.npNext(this.address());
    }

    @NativeType(value="void *")
    public long pHostPointer() {
        return VkImageToMemoryCopyEXT.npHostPointer(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryRowLength() {
        return VkImageToMemoryCopyEXT.nmemoryRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryImageHeight() {
        return VkImageToMemoryCopyEXT.nmemoryImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkImageToMemoryCopyEXT.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkImageToMemoryCopyEXT.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkImageToMemoryCopyEXT.nimageExtent(this.address());
    }

    public VkImageToMemoryCopyEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImageToMemoryCopyEXT.nsType(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT sType$Default() {
        return this.sType(1000270003);
    }

    public VkImageToMemoryCopyEXT pNext(@NativeType(value="void const *") long value) {
        VkImageToMemoryCopyEXT.npNext(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT pHostPointer(@NativeType(value="void *") long value) {
        VkImageToMemoryCopyEXT.npHostPointer(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT memoryRowLength(@NativeType(value="uint32_t") int value) {
        VkImageToMemoryCopyEXT.nmemoryRowLength(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT memoryImageHeight(@NativeType(value="uint32_t") int value) {
        VkImageToMemoryCopyEXT.nmemoryImageHeight(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT imageSubresource(VkImageSubresourceLayers value) {
        VkImageToMemoryCopyEXT.nimageSubresource(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkImageToMemoryCopyEXT imageOffset(VkOffset3D value) {
        VkImageToMemoryCopyEXT.nimageOffset(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkImageToMemoryCopyEXT imageExtent(VkExtent3D value) {
        VkImageToMemoryCopyEXT.nimageExtent(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopyEXT imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkImageToMemoryCopyEXT set(int sType, long pNext, long pHostPointer, int memoryRowLength, int memoryImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.pHostPointer(pHostPointer);
        this.memoryRowLength(memoryRowLength);
        this.memoryImageHeight(memoryImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkImageToMemoryCopyEXT set(VkImageToMemoryCopyEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageToMemoryCopyEXT malloc() {
        return new VkImageToMemoryCopyEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageToMemoryCopyEXT calloc() {
        return new VkImageToMemoryCopyEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageToMemoryCopyEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageToMemoryCopyEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkImageToMemoryCopyEXT create(long address) {
        return new VkImageToMemoryCopyEXT(address, null);
    }

    @Nullable
    public static VkImageToMemoryCopyEXT createSafe(long address) {
        return address == 0L ? null : new VkImageToMemoryCopyEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageToMemoryCopyEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageToMemoryCopyEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageToMemoryCopyEXT malloc(MemoryStack stack) {
        return new VkImageToMemoryCopyEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageToMemoryCopyEXT calloc(MemoryStack stack) {
        return new VkImageToMemoryCopyEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npHostPointer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER);
    }

    public static int nmemoryRowLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYROWLENGTH);
    }

    public static int nmemoryImageHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npHostPointer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PHOSTPOINTER, Checks.check(value));
    }

    public static void nmemoryRowLength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYROWLENGTH, value);
    }

    public static void nmemoryImageHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEEXTENT, VkExtent3D.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER));
    }

    static {
        Struct.Layout layout = VkImageToMemoryCopyEXT.__struct(VkImageToMemoryCopyEXT.__member(4), VkImageToMemoryCopyEXT.__member(POINTER_SIZE), VkImageToMemoryCopyEXT.__member(POINTER_SIZE), VkImageToMemoryCopyEXT.__member(4), VkImageToMemoryCopyEXT.__member(4), VkImageToMemoryCopyEXT.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageToMemoryCopyEXT.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageToMemoryCopyEXT.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHOSTPOINTER = layout.offsetof(2);
        MEMORYROWLENGTH = layout.offsetof(3);
        MEMORYIMAGEHEIGHT = layout.offsetof(4);
        IMAGESUBRESOURCE = layout.offsetof(5);
        IMAGEOFFSET = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkImageToMemoryCopyEXT, Buffer>
    implements NativeResource {
        private static final VkImageToMemoryCopyEXT ELEMENT_FACTORY = VkImageToMemoryCopyEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageToMemoryCopyEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageToMemoryCopyEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageToMemoryCopyEXT.npNext(this.address());
        }

        @NativeType(value="void *")
        public long pHostPointer() {
            return VkImageToMemoryCopyEXT.npHostPointer(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryRowLength() {
            return VkImageToMemoryCopyEXT.nmemoryRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryImageHeight() {
            return VkImageToMemoryCopyEXT.nmemoryImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkImageToMemoryCopyEXT.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkImageToMemoryCopyEXT.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkImageToMemoryCopyEXT.nimageExtent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageToMemoryCopyEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageToMemoryCopyEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pHostPointer(@NativeType(value="void *") long value) {
            VkImageToMemoryCopyEXT.npHostPointer(this.address(), value);
            return this;
        }

        public Buffer memoryRowLength(@NativeType(value="uint32_t") int value) {
            VkImageToMemoryCopyEXT.nmemoryRowLength(this.address(), value);
            return this;
        }

        public Buffer memoryImageHeight(@NativeType(value="uint32_t") int value) {
            VkImageToMemoryCopyEXT.nmemoryImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkImageToMemoryCopyEXT.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkImageToMemoryCopyEXT.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkImageToMemoryCopyEXT.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

