/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageCopy
extends Struct<VkImageCopy>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSET;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSET;
    public static final int EXTENT;

    protected VkImageCopy(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageCopy create(long address, @Nullable ByteBuffer container) {
        return new VkImageCopy(address, container);
    }

    public VkImageCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageCopy.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageCopy.nsrcSubresource(this.address());
    }

    public VkOffset3D srcOffset() {
        return VkImageCopy.nsrcOffset(this.address());
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageCopy.ndstSubresource(this.address());
    }

    public VkOffset3D dstOffset() {
        return VkImageCopy.ndstOffset(this.address());
    }

    public VkExtent3D extent() {
        return VkImageCopy.nextent(this.address());
    }

    public VkImageCopy srcSubresource(VkImageSubresourceLayers value) {
        VkImageCopy.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.srcSubresource());
        return this;
    }

    public VkImageCopy srcOffset(VkOffset3D value) {
        VkImageCopy.nsrcOffset(this.address(), value);
        return this;
    }

    public VkImageCopy srcOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.srcOffset());
        return this;
    }

    public VkImageCopy dstSubresource(VkImageSubresourceLayers value) {
        VkImageCopy.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.dstSubresource());
        return this;
    }

    public VkImageCopy dstOffset(VkOffset3D value) {
        VkImageCopy.ndstOffset(this.address(), value);
        return this;
    }

    public VkImageCopy dstOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.dstOffset());
        return this;
    }

    public VkImageCopy extent(VkExtent3D value) {
        VkImageCopy.nextent(this.address(), value);
        return this;
    }

    public VkImageCopy extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkImageCopy set(VkImageSubresourceLayers srcSubresource, VkOffset3D srcOffset, VkImageSubresourceLayers dstSubresource, VkOffset3D dstOffset, VkExtent3D extent) {
        this.srcSubresource(srcSubresource);
        this.srcOffset(srcOffset);
        this.dstSubresource(dstSubresource);
        this.dstOffset(dstOffset);
        this.extent(extent);
        return this;
    }

    public VkImageCopy set(VkImageCopy src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageCopy malloc() {
        return new VkImageCopy(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageCopy calloc() {
        return new VkImageCopy(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageCopy(MemoryUtil.memAddress(container), container);
    }

    public static VkImageCopy create(long address) {
        return new VkImageCopy(address, null);
    }

    @Nullable
    public static VkImageCopy createSafe(long address) {
        return address == 0L ? null : new VkImageCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageCopy.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageCopy.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImageCopy mallocStack() {
        return VkImageCopy.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageCopy callocStack() {
        return VkImageCopy.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageCopy mallocStack(MemoryStack stack) {
        return VkImageCopy.malloc(stack);
    }

    @Deprecated
    public static VkImageCopy callocStack(MemoryStack stack) {
        return VkImageCopy.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageCopy.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageCopy.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageCopy.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageCopy.calloc(capacity, stack);
    }

    public static VkImageCopy malloc(MemoryStack stack) {
        return new VkImageCopy(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageCopy calloc(MemoryStack stack) {
        return new VkImageCopy(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D nsrcOffset(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSET);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D ndstOffset(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCOFFSET, VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageCopy.__struct(VkImageCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageCopy.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBRESOURCE = layout.offsetof(0);
        SRCOFFSET = layout.offsetof(1);
        DSTSUBRESOURCE = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        EXTENT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageCopy, Buffer>
    implements NativeResource {
        private static final VkImageCopy ELEMENT_FACTORY = VkImageCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageCopy.nsrcSubresource(this.address());
        }

        public VkOffset3D srcOffset() {
            return VkImageCopy.nsrcOffset(this.address());
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageCopy.ndstSubresource(this.address());
        }

        public VkOffset3D dstOffset() {
            return VkImageCopy.ndstOffset(this.address());
        }

        public VkExtent3D extent() {
            return VkImageCopy.nextent(this.address());
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageCopy.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.srcSubresource());
            return this;
        }

        public Buffer srcOffset(VkOffset3D value) {
            VkImageCopy.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer srcOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.srcOffset());
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageCopy.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.dstSubresource());
            return this;
        }

        public Buffer dstOffset(VkOffset3D value) {
            VkImageCopy.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.dstOffset());
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCopy.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

