/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageCompressionControlEXT
extends Struct<VkImageCompressionControlEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int COMPRESSIONCONTROLPLANECOUNT;
    public static final int PFIXEDRATEFLAGS;

    protected VkImageCompressionControlEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageCompressionControlEXT create(long address, @Nullable ByteBuffer container) {
        return new VkImageCompressionControlEXT(address, container);
    }

    public VkImageCompressionControlEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageCompressionControlEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageCompressionControlEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageCompressionControlEXT.npNext(this.address());
    }

    @NativeType(value="VkImageCompressionFlagsEXT")
    public int flags() {
        return VkImageCompressionControlEXT.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int compressionControlPlaneCount() {
        return VkImageCompressionControlEXT.ncompressionControlPlaneCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageCompressionFixedRateFlagsEXT *")
    public IntBuffer pFixedRateFlags() {
        return VkImageCompressionControlEXT.npFixedRateFlags(this.address());
    }

    public VkImageCompressionControlEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImageCompressionControlEXT.nsType(this.address(), value);
        return this;
    }

    public VkImageCompressionControlEXT sType$Default() {
        return this.sType(1000338001);
    }

    public VkImageCompressionControlEXT pNext(@NativeType(value="void const *") long value) {
        VkImageCompressionControlEXT.npNext(this.address(), value);
        return this;
    }

    public VkImageCompressionControlEXT flags(@NativeType(value="VkImageCompressionFlagsEXT") int value) {
        VkImageCompressionControlEXT.nflags(this.address(), value);
        return this;
    }

    public VkImageCompressionControlEXT compressionControlPlaneCount(@NativeType(value="uint32_t") int value) {
        VkImageCompressionControlEXT.ncompressionControlPlaneCount(this.address(), value);
        return this;
    }

    public VkImageCompressionControlEXT pFixedRateFlags(@Nullable @NativeType(value="VkImageCompressionFixedRateFlagsEXT *") IntBuffer value) {
        VkImageCompressionControlEXT.npFixedRateFlags(this.address(), value);
        return this;
    }

    public VkImageCompressionControlEXT set(int sType, long pNext, int flags, int compressionControlPlaneCount, @Nullable IntBuffer pFixedRateFlags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.compressionControlPlaneCount(compressionControlPlaneCount);
        this.pFixedRateFlags(pFixedRateFlags);
        return this;
    }

    public VkImageCompressionControlEXT set(VkImageCompressionControlEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageCompressionControlEXT malloc() {
        return new VkImageCompressionControlEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageCompressionControlEXT calloc() {
        return new VkImageCompressionControlEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageCompressionControlEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageCompressionControlEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkImageCompressionControlEXT create(long address) {
        return new VkImageCompressionControlEXT(address, null);
    }

    @Nullable
    public static VkImageCompressionControlEXT createSafe(long address) {
        return address == 0L ? null : new VkImageCompressionControlEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageCompressionControlEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageCompressionControlEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageCompressionControlEXT malloc(MemoryStack stack) {
        return new VkImageCompressionControlEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageCompressionControlEXT calloc(MemoryStack stack) {
        return new VkImageCompressionControlEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ncompressionControlPlaneCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPRESSIONCONTROLPLANECOUNT);
    }

    @Nullable
    public static IntBuffer npFixedRateFlags(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PFIXEDRATEFLAGS), VkImageCompressionControlEXT.ncompressionControlPlaneCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ncompressionControlPlaneCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPRESSIONCONTROLPLANECOUNT, value);
    }

    public static void npFixedRateFlags(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PFIXEDRATEFLAGS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkImageCompressionControlEXT.ncompressionControlPlaneCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkImageCompressionControlEXT.__struct(VkImageCompressionControlEXT.__member(4), VkImageCompressionControlEXT.__member(POINTER_SIZE), VkImageCompressionControlEXT.__member(4), VkImageCompressionControlEXT.__member(4), VkImageCompressionControlEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        COMPRESSIONCONTROLPLANECOUNT = layout.offsetof(3);
        PFIXEDRATEFLAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageCompressionControlEXT, Buffer>
    implements NativeResource {
        private static final VkImageCompressionControlEXT ELEMENT_FACTORY = VkImageCompressionControlEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageCompressionControlEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageCompressionControlEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageCompressionControlEXT.npNext(this.address());
        }

        @NativeType(value="VkImageCompressionFlagsEXT")
        public int flags() {
            return VkImageCompressionControlEXT.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int compressionControlPlaneCount() {
            return VkImageCompressionControlEXT.ncompressionControlPlaneCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageCompressionFixedRateFlagsEXT *")
        public IntBuffer pFixedRateFlags() {
            return VkImageCompressionControlEXT.npFixedRateFlags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageCompressionControlEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000338001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageCompressionControlEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkImageCompressionFlagsEXT") int value) {
            VkImageCompressionControlEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer compressionControlPlaneCount(@NativeType(value="uint32_t") int value) {
            VkImageCompressionControlEXT.ncompressionControlPlaneCount(this.address(), value);
            return this;
        }

        public Buffer pFixedRateFlags(@Nullable @NativeType(value="VkImageCompressionFixedRateFlagsEXT *") IntBuffer value) {
            VkImageCompressionControlEXT.npFixedRateFlags(this.address(), value);
            return this;
        }
    }
}

