/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageSubresourceRange;

public class VkHostImageLayoutTransitionInfoEXT
extends Struct<VkHostImageLayoutTransitionInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int OLDLAYOUT;
    public static final int NEWLAYOUT;
    public static final int SUBRESOURCERANGE;

    protected VkHostImageLayoutTransitionInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkHostImageLayoutTransitionInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkHostImageLayoutTransitionInfoEXT(address, container);
    }

    public VkHostImageLayoutTransitionInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkHostImageLayoutTransitionInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkHostImageLayoutTransitionInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkHostImageLayoutTransitionInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkHostImageLayoutTransitionInfoEXT.nimage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int oldLayout() {
        return VkHostImageLayoutTransitionInfoEXT.noldLayout(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int newLayout() {
        return VkHostImageLayoutTransitionInfoEXT.nnewLayout(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkHostImageLayoutTransitionInfoEXT.nsubresourceRange(this.address());
    }

    public VkHostImageLayoutTransitionInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkHostImageLayoutTransitionInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT sType$Default() {
        return this.sType(1000270006);
    }

    public VkHostImageLayoutTransitionInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkHostImageLayoutTransitionInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT image(@NativeType(value="VkImage") long value) {
        VkHostImageLayoutTransitionInfoEXT.nimage(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT oldLayout(@NativeType(value="VkImageLayout") int value) {
        VkHostImageLayoutTransitionInfoEXT.noldLayout(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT newLayout(@NativeType(value="VkImageLayout") int value) {
        VkHostImageLayoutTransitionInfoEXT.nnewLayout(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT subresourceRange(VkImageSubresourceRange value) {
        VkHostImageLayoutTransitionInfoEXT.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
        consumer.accept(this.subresourceRange());
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT set(int sType, long pNext, long image, int oldLayout, int newLayout, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.oldLayout(oldLayout);
        this.newLayout(newLayout);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT set(VkHostImageLayoutTransitionInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkHostImageLayoutTransitionInfoEXT malloc() {
        return new VkHostImageLayoutTransitionInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfoEXT calloc() {
        return new VkHostImageLayoutTransitionInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkHostImageLayoutTransitionInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkHostImageLayoutTransitionInfoEXT create(long address) {
        return new VkHostImageLayoutTransitionInfoEXT(address, null);
    }

    @Nullable
    public static VkHostImageLayoutTransitionInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkHostImageLayoutTransitionInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkHostImageLayoutTransitionInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkHostImageLayoutTransitionInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkHostImageLayoutTransitionInfoEXT malloc(MemoryStack stack) {
        return new VkHostImageLayoutTransitionInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfoEXT calloc(MemoryStack stack) {
        return new VkHostImageLayoutTransitionInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGE);
    }

    public static int noldLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)OLDLAYOUT);
    }

    public static int nnewLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)NEWLAYOUT);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGE, value);
    }

    public static void noldLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OLDLAYOUT, value);
    }

    public static void nnewLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NEWLAYOUT, value);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCERANGE, VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkHostImageLayoutTransitionInfoEXT.__struct(VkHostImageLayoutTransitionInfoEXT.__member(4), VkHostImageLayoutTransitionInfoEXT.__member(POINTER_SIZE), VkHostImageLayoutTransitionInfoEXT.__member(8), VkHostImageLayoutTransitionInfoEXT.__member(4), VkHostImageLayoutTransitionInfoEXT.__member(4), VkHostImageLayoutTransitionInfoEXT.__member(VkImageSubresourceRange.SIZEOF, VkImageSubresourceRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        OLDLAYOUT = layout.offsetof(3);
        NEWLAYOUT = layout.offsetof(4);
        SUBRESOURCERANGE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkHostImageLayoutTransitionInfoEXT, Buffer>
    implements NativeResource {
        private static final VkHostImageLayoutTransitionInfoEXT ELEMENT_FACTORY = VkHostImageLayoutTransitionInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkHostImageLayoutTransitionInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkHostImageLayoutTransitionInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkHostImageLayoutTransitionInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkHostImageLayoutTransitionInfoEXT.nimage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int oldLayout() {
            return VkHostImageLayoutTransitionInfoEXT.noldLayout(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int newLayout() {
            return VkHostImageLayoutTransitionInfoEXT.nnewLayout(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkHostImageLayoutTransitionInfoEXT.nsubresourceRange(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkHostImageLayoutTransitionInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkHostImageLayoutTransitionInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkHostImageLayoutTransitionInfoEXT.nimage(this.address(), value);
            return this;
        }

        public Buffer oldLayout(@NativeType(value="VkImageLayout") int value) {
            VkHostImageLayoutTransitionInfoEXT.noldLayout(this.address(), value);
            return this;
        }

        public Buffer newLayout(@NativeType(value="VkImageLayout") int value) {
            VkHostImageLayoutTransitionInfoEXT.nnewLayout(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkHostImageLayoutTransitionInfoEXT.nsubresourceRange(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
            consumer.accept(this.subresourceRange());
            return this;
        }
    }
}

