/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtensionProperties
extends Struct<VkExtensionProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTENSIONNAME;
    public static final int SPECVERSION;

    protected VkExtensionProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExtensionProperties create(long address, @Nullable ByteBuffer container) {
        return new VkExtensionProperties(address, container);
    }

    public VkExtensionProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExtensionProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer extensionName() {
        return VkExtensionProperties.nextensionName(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String extensionNameString() {
        return VkExtensionProperties.nextensionNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int specVersion() {
        return VkExtensionProperties.nspecVersion(this.address());
    }

    public static VkExtensionProperties malloc() {
        return new VkExtensionProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExtensionProperties calloc() {
        return new VkExtensionProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExtensionProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExtensionProperties(MemoryUtil.memAddress(container), container);
    }

    public static VkExtensionProperties create(long address) {
        return new VkExtensionProperties(address, null);
    }

    @Nullable
    public static VkExtensionProperties createSafe(long address) {
        return address == 0L ? null : new VkExtensionProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExtensionProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtensionProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExtensionProperties mallocStack() {
        return VkExtensionProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtensionProperties callocStack() {
        return VkExtensionProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtensionProperties mallocStack(MemoryStack stack) {
        return VkExtensionProperties.malloc(stack);
    }

    @Deprecated
    public static VkExtensionProperties callocStack(MemoryStack stack) {
        return VkExtensionProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExtensionProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExtensionProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtensionProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtensionProperties.calloc(capacity, stack);
    }

    public static VkExtensionProperties malloc(MemoryStack stack) {
        return new VkExtensionProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExtensionProperties calloc(MemoryStack stack) {
        return new VkExtensionProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)EXTENSIONNAME, 256);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)EXTENSIONNAME);
    }

    public static int nspecVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPECVERSION);
    }

    static {
        Struct.Layout layout = VkExtensionProperties.__struct(VkExtensionProperties.__array(1, 256), VkExtensionProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTENSIONNAME = layout.offsetof(0);
        SPECVERSION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkExtensionProperties, Buffer>
    implements NativeResource {
        private static final VkExtensionProperties ELEMENT_FACTORY = VkExtensionProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExtensionProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer extensionName() {
            return VkExtensionProperties.nextensionName(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String extensionNameString() {
            return VkExtensionProperties.nextensionNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int specVersion() {
            return VkExtensionProperties.nspecVersion(this.address());
        }
    }
}

