/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.SECURITY_ATTRIBUTES;

public class VkExportMemoryWin32HandleInfoNV
extends Struct<VkExportMemoryWin32HandleInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PATTRIBUTES;
    public static final int DWACCESS;

    protected VkExportMemoryWin32HandleInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExportMemoryWin32HandleInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkExportMemoryWin32HandleInfoNV(address, container);
    }

    public VkExportMemoryWin32HandleInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExportMemoryWin32HandleInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMemoryWin32HandleInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMemoryWin32HandleInfoNV.npNext(this.address());
    }

    @Nullable
    @NativeType(value="SECURITY_ATTRIBUTES const *")
    public SECURITY_ATTRIBUTES pAttributes() {
        return VkExportMemoryWin32HandleInfoNV.npAttributes(this.address());
    }

    @NativeType(value="DWORD")
    public int dwAccess() {
        return VkExportMemoryWin32HandleInfoNV.ndwAccess(this.address());
    }

    public VkExportMemoryWin32HandleInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryWin32HandleInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoNV sType$Default() {
        return this.sType(1000057001);
    }

    public VkExportMemoryWin32HandleInfoNV pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryWin32HandleInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoNV pAttributes(@Nullable @NativeType(value="SECURITY_ATTRIBUTES const *") SECURITY_ATTRIBUTES value) {
        VkExportMemoryWin32HandleInfoNV.npAttributes(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoNV dwAccess(@NativeType(value="DWORD") int value) {
        VkExportMemoryWin32HandleInfoNV.ndwAccess(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoNV set(int sType, long pNext, @Nullable SECURITY_ATTRIBUTES pAttributes, int dwAccess) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttributes(pAttributes);
        this.dwAccess(dwAccess);
        return this;
    }

    public VkExportMemoryWin32HandleInfoNV set(VkExportMemoryWin32HandleInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryWin32HandleInfoNV malloc() {
        return new VkExportMemoryWin32HandleInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExportMemoryWin32HandleInfoNV calloc() {
        return new VkExportMemoryWin32HandleInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExportMemoryWin32HandleInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExportMemoryWin32HandleInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkExportMemoryWin32HandleInfoNV create(long address) {
        return new VkExportMemoryWin32HandleInfoNV(address, null);
    }

    @Nullable
    public static VkExportMemoryWin32HandleInfoNV createSafe(long address) {
        return address == 0L ? null : new VkExportMemoryWin32HandleInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExportMemoryWin32HandleInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportMemoryWin32HandleInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoNV mallocStack() {
        return VkExportMemoryWin32HandleInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoNV callocStack() {
        return VkExportMemoryWin32HandleInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoNV mallocStack(MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoNV callocStack(MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryWin32HandleInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExportMemoryWin32HandleInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoNV.calloc(capacity, stack);
    }

    public static VkExportMemoryWin32HandleInfoNV malloc(MemoryStack stack) {
        return new VkExportMemoryWin32HandleInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExportMemoryWin32HandleInfoNV calloc(MemoryStack stack) {
        return new VkExportMemoryWin32HandleInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    @Nullable
    public static SECURITY_ATTRIBUTES npAttributes(long struct) {
        return SECURITY_ATTRIBUTES.createSafe(MemoryUtil.memGetAddress(struct + (long)PATTRIBUTES));
    }

    public static int ndwAccess(long struct) {
        return UNSAFE.getInt(null, struct + (long)DWACCESS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npAttributes(long struct, @Nullable SECURITY_ATTRIBUTES value) {
        MemoryUtil.memPutAddress(struct + (long)PATTRIBUTES, MemoryUtil.memAddressSafe(value));
    }

    public static void ndwAccess(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DWACCESS, value);
    }

    public static void validate(long struct) {
        long pAttributes = MemoryUtil.memGetAddress(struct + (long)PATTRIBUTES);
        if (pAttributes != 0L) {
            SECURITY_ATTRIBUTES.validate(pAttributes);
        }
    }

    static {
        Struct.Layout layout = VkExportMemoryWin32HandleInfoNV.__struct(VkExportMemoryWin32HandleInfoNV.__member(4), VkExportMemoryWin32HandleInfoNV.__member(POINTER_SIZE), VkExportMemoryWin32HandleInfoNV.__member(POINTER_SIZE), VkExportMemoryWin32HandleInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PATTRIBUTES = layout.offsetof(2);
        DWACCESS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryWin32HandleInfoNV, Buffer>
    implements NativeResource {
        private static final VkExportMemoryWin32HandleInfoNV ELEMENT_FACTORY = VkExportMemoryWin32HandleInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExportMemoryWin32HandleInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMemoryWin32HandleInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMemoryWin32HandleInfoNV.npNext(this.address());
        }

        @Nullable
        @NativeType(value="SECURITY_ATTRIBUTES const *")
        public SECURITY_ATTRIBUTES pAttributes() {
            return VkExportMemoryWin32HandleInfoNV.npAttributes(this.address());
        }

        @NativeType(value="DWORD")
        public int dwAccess() {
            return VkExportMemoryWin32HandleInfoNV.ndwAccess(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryWin32HandleInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000057001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryWin32HandleInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttributes(@Nullable @NativeType(value="SECURITY_ATTRIBUTES const *") SECURITY_ATTRIBUTES value) {
            VkExportMemoryWin32HandleInfoNV.npAttributes(this.address(), value);
            return this;
        }

        public Buffer dwAccess(@NativeType(value="DWORD") int value) {
            VkExportMemoryWin32HandleInfoNV.ndwAccess(this.address(), value);
            return this;
        }
    }
}

