/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkDisplayPlaneCapabilitiesKHR
extends Struct<VkDisplayPlaneCapabilitiesKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUPPORTEDALPHA;
    public static final int MINSRCPOSITION;
    public static final int MAXSRCPOSITION;
    public static final int MINSRCEXTENT;
    public static final int MAXSRCEXTENT;
    public static final int MINDSTPOSITION;
    public static final int MAXDSTPOSITION;
    public static final int MINDSTEXTENT;
    public static final int MAXDSTEXTENT;

    protected VkDisplayPlaneCapabilitiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDisplayPlaneCapabilitiesKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDisplayPlaneCapabilitiesKHR(address, container);
    }

    public VkDisplayPlaneCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDisplayPlaneCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDisplayPlaneAlphaFlagsKHR")
    public int supportedAlpha() {
        return VkDisplayPlaneCapabilitiesKHR.nsupportedAlpha(this.address());
    }

    public VkOffset2D minSrcPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nminSrcPosition(this.address());
    }

    public VkOffset2D maxSrcPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxSrcPosition(this.address());
    }

    public VkExtent2D minSrcExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nminSrcExtent(this.address());
    }

    public VkExtent2D maxSrcExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxSrcExtent(this.address());
    }

    public VkOffset2D minDstPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nminDstPosition(this.address());
    }

    public VkOffset2D maxDstPosition() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxDstPosition(this.address());
    }

    public VkExtent2D minDstExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nminDstExtent(this.address());
    }

    public VkExtent2D maxDstExtent() {
        return VkDisplayPlaneCapabilitiesKHR.nmaxDstExtent(this.address());
    }

    public static VkDisplayPlaneCapabilitiesKHR malloc() {
        return new VkDisplayPlaneCapabilitiesKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDisplayPlaneCapabilitiesKHR calloc() {
        return new VkDisplayPlaneCapabilitiesKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDisplayPlaneCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDisplayPlaneCapabilitiesKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDisplayPlaneCapabilitiesKHR create(long address) {
        return new VkDisplayPlaneCapabilitiesKHR(address, null);
    }

    @Nullable
    public static VkDisplayPlaneCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : new VkDisplayPlaneCapabilitiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDisplayPlaneCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayPlaneCapabilitiesKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDisplayPlaneCapabilitiesKHR mallocStack() {
        return VkDisplayPlaneCapabilitiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPlaneCapabilitiesKHR callocStack() {
        return VkDisplayPlaneCapabilitiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPlaneCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayPlaneCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayPlaneCapabilitiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayPlaneCapabilitiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlaneCapabilitiesKHR.calloc(capacity, stack);
    }

    public static VkDisplayPlaneCapabilitiesKHR malloc(MemoryStack stack) {
        return new VkDisplayPlaneCapabilitiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDisplayPlaneCapabilitiesKHR calloc(MemoryStack stack) {
        return new VkDisplayPlaneCapabilitiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsupportedAlpha(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDALPHA);
    }

    public static VkOffset2D nminSrcPosition(long struct) {
        return VkOffset2D.create(struct + (long)MINSRCPOSITION);
    }

    public static VkOffset2D nmaxSrcPosition(long struct) {
        return VkOffset2D.create(struct + (long)MAXSRCPOSITION);
    }

    public static VkExtent2D nminSrcExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINSRCEXTENT);
    }

    public static VkExtent2D nmaxSrcExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXSRCEXTENT);
    }

    public static VkOffset2D nminDstPosition(long struct) {
        return VkOffset2D.create(struct + (long)MINDSTPOSITION);
    }

    public static VkOffset2D nmaxDstPosition(long struct) {
        return VkOffset2D.create(struct + (long)MAXDSTPOSITION);
    }

    public static VkExtent2D nminDstExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINDSTEXTENT);
    }

    public static VkExtent2D nmaxDstExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXDSTEXTENT);
    }

    static {
        Struct.Layout layout = VkDisplayPlaneCapabilitiesKHR.__struct(VkDisplayPlaneCapabilitiesKHR.__member(4), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPlaneCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUPPORTEDALPHA = layout.offsetof(0);
        MINSRCPOSITION = layout.offsetof(1);
        MAXSRCPOSITION = layout.offsetof(2);
        MINSRCEXTENT = layout.offsetof(3);
        MAXSRCEXTENT = layout.offsetof(4);
        MINDSTPOSITION = layout.offsetof(5);
        MAXDSTPOSITION = layout.offsetof(6);
        MINDSTEXTENT = layout.offsetof(7);
        MAXDSTEXTENT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPlaneCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayPlaneCapabilitiesKHR ELEMENT_FACTORY = VkDisplayPlaneCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDisplayPlaneCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDisplayPlaneAlphaFlagsKHR")
        public int supportedAlpha() {
            return VkDisplayPlaneCapabilitiesKHR.nsupportedAlpha(this.address());
        }

        public VkOffset2D minSrcPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nminSrcPosition(this.address());
        }

        public VkOffset2D maxSrcPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxSrcPosition(this.address());
        }

        public VkExtent2D minSrcExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nminSrcExtent(this.address());
        }

        public VkExtent2D maxSrcExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxSrcExtent(this.address());
        }

        public VkOffset2D minDstPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nminDstPosition(this.address());
        }

        public VkOffset2D maxDstPosition() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxDstPosition(this.address());
        }

        public VkExtent2D minDstExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nminDstExtent(this.address());
        }

        public VkExtent2D maxDstExtent() {
            return VkDisplayPlaneCapabilitiesKHR.nmaxDstExtent(this.address());
        }
    }
}

