/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDispatchIndirectCommand
extends Struct<VkDispatchIndirectCommand>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected VkDispatchIndirectCommand(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDispatchIndirectCommand create(long address, @Nullable ByteBuffer container) {
        return new VkDispatchIndirectCommand(address, container);
    }

    public VkDispatchIndirectCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDispatchIndirectCommand.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int x() {
        return VkDispatchIndirectCommand.nx(this.address());
    }

    @NativeType(value="uint32_t")
    public int y() {
        return VkDispatchIndirectCommand.ny(this.address());
    }

    @NativeType(value="uint32_t")
    public int z() {
        return VkDispatchIndirectCommand.nz(this.address());
    }

    public VkDispatchIndirectCommand x(@NativeType(value="uint32_t") int value) {
        VkDispatchIndirectCommand.nx(this.address(), value);
        return this;
    }

    public VkDispatchIndirectCommand y(@NativeType(value="uint32_t") int value) {
        VkDispatchIndirectCommand.ny(this.address(), value);
        return this;
    }

    public VkDispatchIndirectCommand z(@NativeType(value="uint32_t") int value) {
        VkDispatchIndirectCommand.nz(this.address(), value);
        return this;
    }

    public VkDispatchIndirectCommand set(int x, int y, int z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public VkDispatchIndirectCommand set(VkDispatchIndirectCommand src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDispatchIndirectCommand malloc() {
        return new VkDispatchIndirectCommand(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDispatchIndirectCommand calloc() {
        return new VkDispatchIndirectCommand(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDispatchIndirectCommand create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDispatchIndirectCommand(MemoryUtil.memAddress(container), container);
    }

    public static VkDispatchIndirectCommand create(long address) {
        return new VkDispatchIndirectCommand(address, null);
    }

    @Nullable
    public static VkDispatchIndirectCommand createSafe(long address) {
        return address == 0L ? null : new VkDispatchIndirectCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDispatchIndirectCommand.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDispatchIndirectCommand.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDispatchIndirectCommand mallocStack() {
        return VkDispatchIndirectCommand.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDispatchIndirectCommand callocStack() {
        return VkDispatchIndirectCommand.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDispatchIndirectCommand mallocStack(MemoryStack stack) {
        return VkDispatchIndirectCommand.malloc(stack);
    }

    @Deprecated
    public static VkDispatchIndirectCommand callocStack(MemoryStack stack) {
        return VkDispatchIndirectCommand.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDispatchIndirectCommand.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDispatchIndirectCommand.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDispatchIndirectCommand.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDispatchIndirectCommand.calloc(capacity, stack);
    }

    public static VkDispatchIndirectCommand malloc(MemoryStack stack) {
        return new VkDispatchIndirectCommand(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDispatchIndirectCommand calloc(MemoryStack stack) {
        return new VkDispatchIndirectCommand(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static int nz(long struct) {
        return UNSAFE.getInt(null, struct + (long)Z);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = VkDispatchIndirectCommand.__struct(VkDispatchIndirectCommand.__member(4), VkDispatchIndirectCommand.__member(4), VkDispatchIndirectCommand.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDispatchIndirectCommand, Buffer>
    implements NativeResource {
        private static final VkDispatchIndirectCommand ELEMENT_FACTORY = VkDispatchIndirectCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDispatchIndirectCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int x() {
            return VkDispatchIndirectCommand.nx(this.address());
        }

        @NativeType(value="uint32_t")
        public int y() {
            return VkDispatchIndirectCommand.ny(this.address());
        }

        @NativeType(value="uint32_t")
        public int z() {
            return VkDispatchIndirectCommand.nz(this.address());
        }

        public Buffer x(@NativeType(value="uint32_t") int value) {
            VkDispatchIndirectCommand.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="uint32_t") int value) {
            VkDispatchIndirectCommand.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="uint32_t") int value) {
            VkDispatchIndirectCommand.nz(this.address(), value);
            return this;
        }
    }
}

