/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceMemoryOpaqueCaptureAddressInfo
extends Struct<VkDeviceMemoryOpaqueCaptureAddressInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;

    protected VkDeviceMemoryOpaqueCaptureAddressInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceMemoryOpaqueCaptureAddressInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(address, container);
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceMemoryOpaqueCaptureAddressInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address());
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo sType$Default() {
        return this.sType(1000257004);
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo set(int sType, long pNext, long memory) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo set(VkDeviceMemoryOpaqueCaptureAddressInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo malloc() {
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo calloc() {
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo create(long address) {
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(address, null);
    }

    @Nullable
    public static VkDeviceMemoryOpaqueCaptureAddressInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceMemoryOpaqueCaptureAddressInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceMemoryOpaqueCaptureAddressInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceMemoryOpaqueCaptureAddressInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo malloc(MemoryStack stack) {
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo calloc(MemoryStack stack) {
        return new VkDeviceMemoryOpaqueCaptureAddressInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    static {
        Struct.Layout layout = VkDeviceMemoryOpaqueCaptureAddressInfo.__struct(VkDeviceMemoryOpaqueCaptureAddressInfo.__member(4), VkDeviceMemoryOpaqueCaptureAddressInfo.__member(POINTER_SIZE), VkDeviceMemoryOpaqueCaptureAddressInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceMemoryOpaqueCaptureAddressInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceMemoryOpaqueCaptureAddressInfo ELEMENT_FACTORY = VkDeviceMemoryOpaqueCaptureAddressInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceMemoryOpaqueCaptureAddressInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000257004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address(), value);
            return this;
        }
    }
}

