/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageToMemoryCopyEXT;

public class VkCopyImageToMemoryInfoEXT
extends Struct<VkCopyImageToMemoryInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyImageToMemoryInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyImageToMemoryInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageToMemoryInfoEXT(address, container);
    }

    public VkCopyImageToMemoryInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCopyImageToMemoryInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyImageToMemoryInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyImageToMemoryInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkHostImageCopyFlagsEXT")
    public int flags() {
        return VkCopyImageToMemoryInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkCopyImageToMemoryInfoEXT.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkCopyImageToMemoryInfoEXT.nsrcImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyImageToMemoryInfoEXT.nregionCount(this.address());
    }

    @NativeType(value="VkImageToMemoryCopyEXT const *")
    public VkImageToMemoryCopyEXT.Buffer pRegions() {
        return VkCopyImageToMemoryInfoEXT.npRegions(this.address());
    }

    public VkCopyImageToMemoryInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToMemoryInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT sType$Default() {
        return this.sType(1000270004);
    }

    public VkCopyImageToMemoryInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToMemoryInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT flags(@NativeType(value="VkHostImageCopyFlagsEXT") int value) {
        VkCopyImageToMemoryInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToMemoryInfoEXT.nsrcImage(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToMemoryInfoEXT.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT pRegions(@NativeType(value="VkImageToMemoryCopyEXT const *") VkImageToMemoryCopyEXT.Buffer value) {
        VkCopyImageToMemoryInfoEXT.npRegions(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT set(int sType, long pNext, int flags, long srcImage, int srcImageLayout, VkImageToMemoryCopyEXT.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT set(VkCopyImageToMemoryInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyImageToMemoryInfoEXT malloc() {
        return new VkCopyImageToMemoryInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfoEXT calloc() {
        return new VkCopyImageToMemoryInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyImageToMemoryInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyImageToMemoryInfoEXT create(long address) {
        return new VkCopyImageToMemoryInfoEXT(address, null);
    }

    @Nullable
    public static VkCopyImageToMemoryInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyImageToMemoryInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyImageToMemoryInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToMemoryInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageToMemoryInfoEXT malloc(MemoryStack stack) {
        return new VkCopyImageToMemoryInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfoEXT calloc(MemoryStack stack) {
        return new VkCopyImageToMemoryInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nsrcImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCIMAGE);
    }

    public static int nsrcImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCIMAGELAYOUT);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkImageToMemoryCopyEXT.Buffer npRegions(long struct) {
        return VkImageToMemoryCopyEXT.create(MemoryUtil.memGetAddress(struct + (long)PREGIONS), VkCopyImageToMemoryInfoEXT.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsrcImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCIMAGE, value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCIMAGELAYOUT, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkImageToMemoryCopyEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREGIONS, value.address());
        VkCopyImageToMemoryInfoEXT.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int regionCount = VkCopyImageToMemoryInfoEXT.nregionCount(struct);
        long pRegions = MemoryUtil.memGetAddress(struct + (long)PREGIONS);
        Checks.check(pRegions);
        VkCopyImageToMemoryInfoEXT.validate(pRegions, regionCount, VkImageToMemoryCopyEXT.SIZEOF, VkImageToMemoryCopyEXT::validate);
    }

    static {
        Struct.Layout layout = VkCopyImageToMemoryInfoEXT.__struct(VkCopyImageToMemoryInfoEXT.__member(4), VkCopyImageToMemoryInfoEXT.__member(POINTER_SIZE), VkCopyImageToMemoryInfoEXT.__member(4), VkCopyImageToMemoryInfoEXT.__member(8), VkCopyImageToMemoryInfoEXT.__member(4), VkCopyImageToMemoryInfoEXT.__member(4), VkCopyImageToMemoryInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SRCIMAGE = layout.offsetof(3);
        SRCIMAGELAYOUT = layout.offsetof(4);
        REGIONCOUNT = layout.offsetof(5);
        PREGIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkCopyImageToMemoryInfoEXT, Buffer>
    implements NativeResource {
        private static final VkCopyImageToMemoryInfoEXT ELEMENT_FACTORY = VkCopyImageToMemoryInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCopyImageToMemoryInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyImageToMemoryInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyImageToMemoryInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkHostImageCopyFlagsEXT")
        public int flags() {
            return VkCopyImageToMemoryInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkCopyImageToMemoryInfoEXT.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkCopyImageToMemoryInfoEXT.nsrcImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyImageToMemoryInfoEXT.nregionCount(this.address());
        }

        @NativeType(value="VkImageToMemoryCopyEXT const *")
        public VkImageToMemoryCopyEXT.Buffer pRegions() {
            return VkCopyImageToMemoryInfoEXT.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToMemoryInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToMemoryInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkHostImageCopyFlagsEXT") int value) {
            VkCopyImageToMemoryInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToMemoryInfoEXT.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToMemoryInfoEXT.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageToMemoryCopyEXT const *") VkImageToMemoryCopyEXT.Buffer value) {
            VkCopyImageToMemoryInfoEXT.npRegions(this.address(), value);
            return this;
        }
    }
}

