/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCommandBuffer;

public class VkCommandBufferSubmitInfo
extends Struct<VkCommandBufferSubmitInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COMMANDBUFFER;
    public static final int DEVICEMASK;

    protected VkCommandBufferSubmitInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCommandBufferSubmitInfo create(long address, @Nullable ByteBuffer container) {
        return new VkCommandBufferSubmitInfo(address, container);
    }

    public VkCommandBufferSubmitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCommandBufferSubmitInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandBufferSubmitInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandBufferSubmitInfo.npNext(this.address());
    }

    @NativeType(value="VkCommandBuffer")
    public long commandBuffer() {
        return VkCommandBufferSubmitInfo.ncommandBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkCommandBufferSubmitInfo.ndeviceMask(this.address());
    }

    public VkCommandBufferSubmitInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandBufferSubmitInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferSubmitInfo sType$Default() {
        return this.sType(1000314006);
    }

    public VkCommandBufferSubmitInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandBufferSubmitInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferSubmitInfo commandBuffer(VkCommandBuffer value) {
        VkCommandBufferSubmitInfo.ncommandBuffer(this.address(), value);
        return this;
    }

    public VkCommandBufferSubmitInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkCommandBufferSubmitInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkCommandBufferSubmitInfo set(int sType, long pNext, VkCommandBuffer commandBuffer, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.commandBuffer(commandBuffer);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkCommandBufferSubmitInfo set(VkCommandBufferSubmitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCommandBufferSubmitInfo malloc() {
        return new VkCommandBufferSubmitInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCommandBufferSubmitInfo calloc() {
        return new VkCommandBufferSubmitInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCommandBufferSubmitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCommandBufferSubmitInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkCommandBufferSubmitInfo create(long address) {
        return new VkCommandBufferSubmitInfo(address, null);
    }

    @Nullable
    public static VkCommandBufferSubmitInfo createSafe(long address) {
        return address == 0L ? null : new VkCommandBufferSubmitInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCommandBufferSubmitInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCommandBufferSubmitInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCommandBufferSubmitInfo malloc(MemoryStack stack) {
        return new VkCommandBufferSubmitInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCommandBufferSubmitInfo calloc(MemoryStack stack) {
        return new VkCommandBufferSubmitInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ncommandBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COMMANDBUFFER);
    }

    public static int ndeviceMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncommandBuffer(long struct, VkCommandBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)COMMANDBUFFER, value.address());
    }

    public static void ndeviceMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEMASK, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COMMANDBUFFER));
    }

    static {
        Struct.Layout layout = VkCommandBufferSubmitInfo.__struct(VkCommandBufferSubmitInfo.__member(4), VkCommandBufferSubmitInfo.__member(POINTER_SIZE), VkCommandBufferSubmitInfo.__member(POINTER_SIZE), VkCommandBufferSubmitInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COMMANDBUFFER = layout.offsetof(2);
        DEVICEMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferSubmitInfo, Buffer>
    implements NativeResource {
        private static final VkCommandBufferSubmitInfo ELEMENT_FACTORY = VkCommandBufferSubmitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCommandBufferSubmitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandBufferSubmitInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandBufferSubmitInfo.npNext(this.address());
        }

        @NativeType(value="VkCommandBuffer")
        public long commandBuffer() {
            return VkCommandBufferSubmitInfo.ncommandBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkCommandBufferSubmitInfo.ndeviceMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandBufferSubmitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandBufferSubmitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer commandBuffer(VkCommandBuffer value) {
            VkCommandBufferSubmitInfo.ncommandBuffer(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkCommandBufferSubmitInfo.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

