/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferOpaqueCaptureAddressCreateInfo
extends Struct<VkBufferOpaqueCaptureAddressCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OPAQUECAPTUREADDRESS;

    protected VkBufferOpaqueCaptureAddressCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferOpaqueCaptureAddressCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBufferOpaqueCaptureAddressCreateInfo(address, container);
    }

    public VkBufferOpaqueCaptureAddressCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferOpaqueCaptureAddressCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferOpaqueCaptureAddressCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferOpaqueCaptureAddressCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint64_t")
    public long opaqueCaptureAddress() {
        return VkBufferOpaqueCaptureAddressCreateInfo.nopaqueCaptureAddress(this.address());
    }

    public VkBufferOpaqueCaptureAddressCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBufferOpaqueCaptureAddressCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferOpaqueCaptureAddressCreateInfo sType$Default() {
        return this.sType(1000257002);
    }

    public VkBufferOpaqueCaptureAddressCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkBufferOpaqueCaptureAddressCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferOpaqueCaptureAddressCreateInfo opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
        VkBufferOpaqueCaptureAddressCreateInfo.nopaqueCaptureAddress(this.address(), value);
        return this;
    }

    public VkBufferOpaqueCaptureAddressCreateInfo set(int sType, long pNext, long opaqueCaptureAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.opaqueCaptureAddress(opaqueCaptureAddress);
        return this;
    }

    public VkBufferOpaqueCaptureAddressCreateInfo set(VkBufferOpaqueCaptureAddressCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferOpaqueCaptureAddressCreateInfo malloc() {
        return new VkBufferOpaqueCaptureAddressCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfo calloc() {
        return new VkBufferOpaqueCaptureAddressCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBufferOpaqueCaptureAddressCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfo create(long address) {
        return new VkBufferOpaqueCaptureAddressCreateInfo(address, null);
    }

    @Nullable
    public static VkBufferOpaqueCaptureAddressCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkBufferOpaqueCaptureAddressCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBufferOpaqueCaptureAddressCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferOpaqueCaptureAddressCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfo malloc(MemoryStack stack) {
        return new VkBufferOpaqueCaptureAddressCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferOpaqueCaptureAddressCreateInfo calloc(MemoryStack stack) {
        return new VkBufferOpaqueCaptureAddressCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nopaqueCaptureAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)OPAQUECAPTUREADDRESS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nopaqueCaptureAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OPAQUECAPTUREADDRESS, value);
    }

    static {
        Struct.Layout layout = VkBufferOpaqueCaptureAddressCreateInfo.__struct(VkBufferOpaqueCaptureAddressCreateInfo.__member(4), VkBufferOpaqueCaptureAddressCreateInfo.__member(POINTER_SIZE), VkBufferOpaqueCaptureAddressCreateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OPAQUECAPTUREADDRESS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferOpaqueCaptureAddressCreateInfo, Buffer>
    implements NativeResource {
        private static final VkBufferOpaqueCaptureAddressCreateInfo ELEMENT_FACTORY = VkBufferOpaqueCaptureAddressCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferOpaqueCaptureAddressCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferOpaqueCaptureAddressCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferOpaqueCaptureAddressCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint64_t")
        public long opaqueCaptureAddress() {
            return VkBufferOpaqueCaptureAddressCreateInfo.nopaqueCaptureAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferOpaqueCaptureAddressCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000257002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferOpaqueCaptureAddressCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
            VkBufferOpaqueCaptureAddressCreateInfo.nopaqueCaptureAddress(this.address(), value);
            return this;
        }
    }
}

