/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferDeviceAddressInfo;

public class VkBufferDeviceAddressInfoKHR
extends VkBufferDeviceAddressInfo {
    protected VkBufferDeviceAddressInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferDeviceAddressInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkBufferDeviceAddressInfoKHR(address, container);
    }

    public VkBufferDeviceAddressInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferDeviceAddressInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoKHR sType$Default() {
        return this.sType(1000244001);
    }

    @Override
    public VkBufferDeviceAddressInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferDeviceAddressInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoKHR set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferDeviceAddressInfoKHR set(VkBufferDeviceAddressInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressInfoKHR malloc() {
        return new VkBufferDeviceAddressInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBufferDeviceAddressInfoKHR calloc() {
        return new VkBufferDeviceAddressInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBufferDeviceAddressInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBufferDeviceAddressInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkBufferDeviceAddressInfoKHR create(long address) {
        return new VkBufferDeviceAddressInfoKHR(address, null);
    }

    @Nullable
    public static VkBufferDeviceAddressInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkBufferDeviceAddressInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBufferDeviceAddressInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferDeviceAddressInfoKHR malloc(MemoryStack stack) {
        return new VkBufferDeviceAddressInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferDeviceAddressInfoKHR calloc(MemoryStack stack) {
        return new VkBufferDeviceAddressInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferDeviceAddressInfo.Buffer {
        private static final VkBufferDeviceAddressInfoKHR ELEMENT_FACTORY = VkBufferDeviceAddressInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferDeviceAddressInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000244001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferDeviceAddressInfoKHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

