/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkWaylandSurfaceCreateInfoKHR;

public class KHRWaylandSurface {
    public static final int VK_KHR_WAYLAND_SURFACE_SPEC_VERSION = 6;
    public static final String VK_KHR_WAYLAND_SURFACE_EXTENSION_NAME = "VK_KHR_wayland_surface";
    public static final int VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR = 1000006000;

    protected KHRWaylandSurface() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateWaylandSurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateWaylandSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(instance.address(), pCreateInfo, pAllocator, pSurface, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateWaylandSurfaceKHR(VkInstance instance, @NativeType(value="VkWaylandSurfaceCreateInfoKHR const *") VkWaylandSurfaceCreateInfoKHR pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, 1);
        }
        return KHRWaylandSurface.nvkCreateWaylandSurfaceKHR(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pSurface));
    }

    @NativeType(value="VkBool32")
    public static boolean vkGetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="struct wl_display *") long display) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceWaylandPresentationSupportKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
        }
        return JNI.callPPI(physicalDevice.address(), queueFamilyIndex, display, __functionAddress) != 0;
    }

    @NativeType(value="VkResult")
    public static int vkCreateWaylandSurfaceKHR(VkInstance instance, @NativeType(value="VkWaylandSurfaceCreateInfoKHR const *") VkWaylandSurfaceCreateInfoKHR pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateWaylandSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSurface, 1);
        }
        return JNI.callPPPPI(instance.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pSurface, __functionAddress);
    }
}

