/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPipelineExecutableInfoKHR;
import org.lwjgl.vulkan.VkPipelineExecutableInternalRepresentationKHR;
import org.lwjgl.vulkan.VkPipelineExecutablePropertiesKHR;
import org.lwjgl.vulkan.VkPipelineExecutableStatisticKHR;
import org.lwjgl.vulkan.VkPipelineInfoKHR;

public class KHRPipelineExecutableProperties {
    public static final int VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION = 1;
    public static final String VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION_NAME = "VK_KHR_pipeline_executable_properties";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR = 1000269000;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR = 1000269001;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR = 1000269002;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR = 1000269003;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR = 1000269004;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR = 1000269005;
    public static final int VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR = 64;
    public static final int VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR = 128;
    public static final int VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR = 0;
    public static final int VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR = 1;
    public static final int VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR = 2;
    public static final int VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR = 3;

    protected KHRPipelineExecutableProperties() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPipelineExecutablePropertiesKHR(VkDevice device, long pPipelineInfo, long pExecutableCount, long pProperties) {
        long __functionAddress = device.getCapabilities().vkGetPipelineExecutablePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(device.address(), pPipelineInfo, pExecutableCount, pProperties, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineExecutablePropertiesKHR(VkDevice device, @NativeType(value="VkPipelineInfoKHR const *") VkPipelineInfoKHR pPipelineInfo, @NativeType(value="uint32_t *") IntBuffer pExecutableCount, @Nullable @NativeType(value="VkPipelineExecutablePropertiesKHR *") VkPipelineExecutablePropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pExecutableCount, 1);
            Checks.checkSafe(pProperties, pExecutableCount.get(pExecutableCount.position()));
        }
        return KHRPipelineExecutableProperties.nvkGetPipelineExecutablePropertiesKHR(device, pPipelineInfo.address(), MemoryUtil.memAddress(pExecutableCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkGetPipelineExecutableStatisticsKHR(VkDevice device, long pExecutableInfo, long pStatisticCount, long pStatistics) {
        long __functionAddress = device.getCapabilities().vkGetPipelineExecutableStatisticsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(device.address(), pExecutableInfo, pStatisticCount, pStatistics, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineExecutableStatisticsKHR(VkDevice device, @NativeType(value="VkPipelineExecutableInfoKHR const *") VkPipelineExecutableInfoKHR pExecutableInfo, @NativeType(value="uint32_t *") IntBuffer pStatisticCount, @Nullable @NativeType(value="VkPipelineExecutableStatisticKHR *") VkPipelineExecutableStatisticKHR.Buffer pStatistics) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pStatisticCount, 1);
            Checks.checkSafe(pStatistics, pStatisticCount.get(pStatisticCount.position()));
        }
        return KHRPipelineExecutableProperties.nvkGetPipelineExecutableStatisticsKHR(device, pExecutableInfo.address(), MemoryUtil.memAddress(pStatisticCount), MemoryUtil.memAddressSafe(pStatistics));
    }

    public static int nvkGetPipelineExecutableInternalRepresentationsKHR(VkDevice device, long pExecutableInfo, long pInternalRepresentationCount, long pInternalRepresentations) {
        long __functionAddress = device.getCapabilities().vkGetPipelineExecutableInternalRepresentationsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(device.address(), pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineExecutableInternalRepresentationsKHR(VkDevice device, @NativeType(value="VkPipelineExecutableInfoKHR const *") VkPipelineExecutableInfoKHR pExecutableInfo, @NativeType(value="uint32_t *") IntBuffer pInternalRepresentationCount, @Nullable @NativeType(value="VkPipelineExecutableInternalRepresentationKHR *") VkPipelineExecutableInternalRepresentationKHR.Buffer pInternalRepresentations) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pInternalRepresentationCount, 1);
            Checks.checkSafe(pInternalRepresentations, pInternalRepresentationCount.get(pInternalRepresentationCount.position()));
        }
        return KHRPipelineExecutableProperties.nvkGetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo.address(), MemoryUtil.memAddress(pInternalRepresentationCount), MemoryUtil.memAddressSafe(pInternalRepresentations));
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineExecutablePropertiesKHR(VkDevice device, @NativeType(value="VkPipelineInfoKHR const *") VkPipelineInfoKHR pPipelineInfo, @NativeType(value="uint32_t *") int[] pExecutableCount, @Nullable @NativeType(value="VkPipelineExecutablePropertiesKHR *") VkPipelineExecutablePropertiesKHR.Buffer pProperties) {
        long __functionAddress = device.getCapabilities().vkGetPipelineExecutablePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pExecutableCount, 1);
            Checks.checkSafe(pProperties, pExecutableCount[0]);
        }
        return JNI.callPPPPI(device.address(), pPipelineInfo.address(), pExecutableCount, MemoryUtil.memAddressSafe(pProperties), __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineExecutableStatisticsKHR(VkDevice device, @NativeType(value="VkPipelineExecutableInfoKHR const *") VkPipelineExecutableInfoKHR pExecutableInfo, @NativeType(value="uint32_t *") int[] pStatisticCount, @Nullable @NativeType(value="VkPipelineExecutableStatisticKHR *") VkPipelineExecutableStatisticKHR.Buffer pStatistics) {
        long __functionAddress = device.getCapabilities().vkGetPipelineExecutableStatisticsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pStatisticCount, 1);
            Checks.checkSafe(pStatistics, pStatisticCount[0]);
        }
        return JNI.callPPPPI(device.address(), pExecutableInfo.address(), pStatisticCount, MemoryUtil.memAddressSafe(pStatistics), __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPipelineExecutableInternalRepresentationsKHR(VkDevice device, @NativeType(value="VkPipelineExecutableInfoKHR const *") VkPipelineExecutableInfoKHR pExecutableInfo, @NativeType(value="uint32_t *") int[] pInternalRepresentationCount, @Nullable @NativeType(value="VkPipelineExecutableInternalRepresentationKHR *") VkPipelineExecutableInternalRepresentationKHR.Buffer pInternalRepresentations) {
        long __functionAddress = device.getCapabilities().vkGetPipelineExecutableInternalRepresentationsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pInternalRepresentationCount, 1);
            Checks.checkSafe(pInternalRepresentations, pInternalRepresentationCount[0]);
        }
        return JNI.callPPPPI(device.address(), pExecutableInfo.address(), pInternalRepresentationCount, MemoryUtil.memAddressSafe(pInternalRepresentations), __functionAddress);
    }
}

