/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.util.regex.Matcher;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;
import org.openstreetmap.josm.tools.I18n;

public class LambertCC9ZonesProjectionPatterns
extends ProjectionPatterns {
    public static final Projection[] lambertCC9Zones = new Projection[9];

    public LambertCC9ZonesProjectionPatterns(String proj) {
        super(proj);
    }

    @Override
    public Projection getProjection(String xFieldName, String yFieldName) {
        Matcher mx = this.getXPattern().matcher(xFieldName);
        Matcher my = this.getYPattern().matcher(yFieldName);
        mx.find();
        my.find();
        String ccx = mx.group(1);
        String ccy = mx.group(1);
        if (!ccx.equals(ccy)) {
            throw new IllegalArgumentException(I18n.tr((String)("''Lambert CC 9 zones'' coordinates found with different zone codes for X and Y: " + xFieldName + ", " + yFieldName), (Object[])new Object[0]));
        }
        return lambertCC9Zones[Integer.parseInt(ccx) - 42];
    }

    static {
        for (int i = 0; i < lambertCC9Zones.length; ++i) {
            LambertCC9ZonesProjectionPatterns.lambertCC9Zones[i] = Projections.getProjectionByCode((String)("EPSG:" + (3942 + i)));
        }
    }
}

