/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.actions;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetUpdater;
import org.openstreetmap.josm.plugins.opendata.core.gui.AskLicenseAgreementDialog;
import org.openstreetmap.josm.plugins.opendata.core.io.NetworkReader;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DownloadDataTask
extends DownloadOsmTask {
    private AbstractDataSetHandler handler;

    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new InternalDownloadTask(settings, new NetworkReader(url, this.handler, true), progressMonitor, this.zoomAfterDownload);
        this.currentBounds = null;
        if (this.handler == null || !this.handler.hasLicenseToBeAccepted() || this.askLicenseAgreement(this.handler.getLicense())) {
            return MainApplication.worker.submit((Runnable)this.downloadTask);
        }
        return null;
    }

    public boolean acceptsUrl(String url) {
        this.handler = null;
        for (Module module : ModuleHandler.moduleList) {
            for (AbstractDataSetHandler moduleHandler : module.getNewlyInstanciatedHandlers()) {
                if (!moduleHandler.acceptsUrl(url)) continue;
                this.handler = moduleHandler;
                return true;
            }
        }
        for (String ext : NetworkReader.FILE_AND_ARCHIVE_READERS.keySet()) {
            if (!Pattern.compile(".*\\." + ext, 2).matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] getPatterns() {
        StringBuilder pattern = new StringBuilder();
        for (String ext : NetworkReader.FILE_AND_ARCHIVE_READERS.keySet()) {
            if (pattern.length() > 0) {
                pattern.append('|');
            }
            pattern.append('.').append(ext);
        }
        return new String[]{".*(" + pattern + ")"};
    }

    public String getTitle() {
        return I18n.tr((String)"Download open data", (Object[])new Object[0]);
    }

    protected final boolean askLicenseAgreement(License license) {
        if (license == null || license.getURL() == null && license.getSummaryURL() == null) {
            return true;
        }
        try {
            return new AskLicenseAgreementDialog(license).showDialog().getValue() == 1;
        }
        catch (IOException e) {
            Logging.debug((Throwable)e);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"License URL not available: {0}", (Object[])new Object[]{license.toString()}));
            return false;
        }
    }

    protected class InternalDownloadTask
    extends DownloadOsmTask.DownloadTask {
        public InternalDownloadTask(DownloadParams settings, NetworkReader reader, ProgressMonitor progressMonitor, boolean zoomAfterDownload) {
            super((DownloadOsmTask)DownloadDataTask.this, settings, (OsmServerReader)reader, progressMonitor, zoomAfterDownload);
        }

        protected OsmDataLayer createNewLayer(DataSet ds, Optional<String> optLayerName) {
            File associatedFile = ((NetworkReader)this.reader).getReadFile();
            String filename = ((NetworkReader)this.reader).getReadFileName();
            String layerName = optLayerName.orElse("");
            if (layerName.isEmpty()) {
                layerName = associatedFile != null ? associatedFile.getName() : (filename != null && !filename.isEmpty() ? filename : OsmDataLayer.createNewName());
            }
            DataSetUpdater.updateDataSet(this.dataSet, DownloadDataTask.this.handler, associatedFile);
            return new OdDataLayer(this.dataSet, layerName, associatedFile, DownloadDataTask.this.handler);
        }
    }
}

