/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class GraphicsUtils {
    static final Logger logger = Logger.getLogger(GraphicsUtils.class);

    private GraphicsUtils() {
    }

    public static javafx.scene.image.Image convertBufferedImage2JavaFXImage(BufferedImage bf) {
        WritableImage res = null;
        if (bf != null) {
            res = new WritableImage(bf.getWidth(), bf.getHeight());
            PixelWriter pw = res.getPixelWriter();
            for (int x = 0; x < bf.getWidth(); ++x) {
                for (int y = 0; y < bf.getHeight(); ++y) {
                    pw.setArgb(x, y, bf.getRGB(x, y));
                }
            }
        }
        return res;
    }

    public static BufferedImage buildMultiTiledCubemapFaceImage(BufferedImage[] tiles) {
        long start = System.currentTimeMillis();
        BufferedImage res = null;
        int pixelBuffer = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 2 : 1;
        BufferedImage[] croppedTiles = GraphicsUtils.cropMultiTiledImages(tiles, pixelBuffer);
        int rows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int cols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int chunkWidth = croppedTiles[0].getWidth();
        int chunkHeight = croppedTiles[0].getHeight();
        BufferedImage img = new BufferedImage(chunkWidth * cols, chunkHeight * rows, 2);
        int num = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int width;
                img.createGraphics().drawImage((Image)croppedTiles[num], chunkWidth * j, chunkHeight * i, null);
                int height = width = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 1014 : 510;
                res = new BufferedImage(width, height, 2);
                for (int y = 0; y < height; ++y) {
                    int lx = 0;
                    int rx = width - 1;
                    while (lx < width) {
                        int p = img.getRGB(lx, y);
                        res.setRGB(rx, y, p);
                        ++lx;
                        --rx;
                    }
                }
                ++num;
            }
        }
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug((Object)MessageFormat.format("Image concatenated in {0} millisecs.", System.currentTimeMillis() - start));
        }
        return res;
    }

    public static BufferedImage rotateImage(BufferedImage bufImg) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bufImg.getWidth(null), -bufImg.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufImg = op.filter(bufImg, null);
        return bufImg;
    }

    private static BufferedImage[] cropMultiTiledImages(BufferedImage[] tiles, int pixelBuffer) {
        long start = System.currentTimeMillis();
        BufferedImage[] res = new BufferedImage[tiles.length];
        for (int i = 0; i < tiles.length; ++i) {
            res[i] = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? tiles[i].getSubimage(pixelBuffer, pixelBuffer, 256 - pixelBuffer, 256 - pixelBuffer) : tiles[i].getSubimage(pixelBuffer, pixelBuffer, 256 - pixelBuffer, 256 - pixelBuffer);
        }
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug((Object)MessageFormat.format("Images cropped in {0} millisecs.", System.currentTimeMillis() - start));
        }
        return res;
    }

    public static class PlatformHelper {
        private PlatformHelper() {
        }

        public static void run(Runnable treatment) {
            if (treatment == null) {
                throw new IllegalArgumentException("The treatment to perform can not be null");
            }
            if (Platform.isFxApplicationThread()) {
                treatment.run();
            } else {
                Platform.runLater((Runnable)treatment);
            }
        }
    }
}

