/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.mult;

import java.util.Arrays;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.dense.row.MatrixFeatures_DDRM;

public class MatrixVectorMult_DSCC {
    public static void mult(DMatrixSparseCSC A, double[] b, int offsetB, double[] c, int offsetC) {
        Arrays.fill(c, offsetC, offsetC + A.numRows, 0.0);
        MatrixVectorMult_DSCC.multAdd(A, b, offsetB, c, offsetC);
    }

    public static void multAdd(DMatrixSparseCSC A, double[] b, int offsetB, double[] c, int offsetC) {
        if (b.length - offsetB < A.numCols) {
            throw new IllegalArgumentException("Length of 'b' isn't long enough");
        }
        if (c.length - offsetC < A.numRows) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        for (int k = 0; k < A.numCols; ++k) {
            int idx0 = A.col_idx[k];
            int idx1 = A.col_idx[k + 1];
            for (int indexA = idx0; indexA < idx1; ++indexA) {
                int n = offsetC + A.nz_rows[indexA];
                c[n] = c[n] + A.nz_values[indexA] * b[offsetB + k];
            }
        }
    }

    public static void mult(double[] a, int offsetA, DMatrixSparseCSC B, double[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        for (int k = 0; k < B.numCols; ++k) {
            int idx0 = B.col_idx[k];
            int idx1 = B.col_idx[k + 1];
            double sum = 0.0;
            for (int indexB = idx0; indexB < idx1; ++indexB) {
                sum += a[offsetA + B.nz_rows[indexB]] * B.nz_values[indexB];
            }
            c[offsetC + k] = sum;
        }
    }

    public static double innerProduct(double[] a, int offsetA, DMatrixSparseCSC B, double[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        double output = 0.0;
        for (int k = 0; k < B.numCols; ++k) {
            int idx0 = B.col_idx[k];
            int idx1 = B.col_idx[k + 1];
            double sum = 0.0;
            for (int indexB = idx0; indexB < idx1; ++indexB) {
                sum += a[offsetA + B.nz_rows[indexB]] * B.nz_values[indexB];
            }
            output += sum * c[offsetC + k];
        }
        return output;
    }

    private static void checkInnerProductArguments(DMatrixSparseCSC A, DMatrix1Row B, DMatrixSparseCSC C) {
        UtilEjml.assertTrue(MatrixFeatures_DDRM.isVector(A), "'A' must be a vector");
        UtilEjml.assertEq(1, A.numCols, "'A' must be a column vector");
        UtilEjml.assertShape(A.getNumElements(), B.numRows, "Length of 'A' vector not equal to number of rows in 'B' matrix");
        UtilEjml.assertTrue(MatrixFeatures_DDRM.isVector(C), "'C' must be a vector");
        UtilEjml.assertEq(1, C.numCols, "'C' must be a column vector");
        UtilEjml.assertShape(C.getNumElements(), B.numCols, "Length of 'C' vector not equal to number of columns in 'B' matrix");
    }

    public static double innerProduct(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixSparseCSC C) {
        MatrixVectorMult_DSCC.checkInnerProductArguments(A, B, C);
        double output = 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            int b_offset = A.nz_rows[i] * B.numCols;
            double sum = 0.0;
            for (int j = 0; j < C.nz_length; ++j) {
                sum += C.nz_values[j] * B.data[b_offset + C.nz_rows[j]];
            }
            output += A.nz_values[i] * sum;
        }
        return output;
    }

    private static void checkInnerProductSelfSymmetricalArguments(DMatrixSparseCSC A, DMatrix1Row B) {
        UtilEjml.assertTrue(MatrixFeatures_DDRM.isVector(A), "'A' must be a vector");
        UtilEjml.assertEq(1, A.numCols, "'A' must be a column vector");
        UtilEjml.assertTrue(MatrixFeatures_DDRM.isSquare(B), "'B' must be a square matrix");
        UtilEjml.assertShape(A.getNumElements(), B.numRows, "Length of 'A' vector not equal to number of rows / columns in 'B' matrix");
    }

    public static double innerProductSelfSymmetrical(DMatrixSparseCSC A, DMatrixRMaj B) {
        MatrixVectorMult_DSCC.checkInnerProductSelfSymmetricalArguments(A, B);
        double output = 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            int index1 = A.nz_rows[i];
            double value1 = A.nz_values[i];
            int b_offset = index1 * B.numCols;
            double diagonalValue = B.data[b_offset + index1];
            double sum = 0.0;
            for (int j = i + 1; j < A.nz_length; ++j) {
                sum += A.nz_values[j] * B.data[b_offset + A.nz_rows[j]];
            }
            output += value1 * value1 * diagonalValue + value1 * (sum + sum);
        }
        return output;
    }
}

