/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.EjmlParameters;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.MatrixIO;

public class BlockD3Matrix64F
implements ReshapeMatrix,
DMatrix {
    public int blockLength;
    public double[][][] blocks;
    public int numRows;
    public int numCols;

    public BlockD3Matrix64F(int numRows, int numCols, int blockLength) {
        this.blockLength = blockLength;
        this.reshape(numRows, numCols);
    }

    public BlockD3Matrix64F(int numRows, int numCols) {
        this(numRows, numCols, EjmlParameters.BLOCK_WIDTH);
    }

    public double[][][] getData() {
        return this.blocks;
    }

    @Override
    public void reshape(int numRows, int numCols) {
        UtilEjml.checkValidMatrixShape(numRows, numCols);
        this.numRows = numRows;
        this.numCols = numCols;
        int blockM = numRows / this.blockLength;
        int blockN = numCols / this.blockLength;
        if (numRows % this.blockLength > 0) {
            ++blockM;
        }
        if (numCols % this.blockLength > 0) {
            ++blockN;
        }
        this.blocks = new double[blockM][blockN][];
        for (int i = 0; i < numRows; i += this.blockLength) {
            int ii = i / this.blockLength;
            for (int j = 0; j < numCols; j += this.blockLength) {
                int jj = j / this.blockLength;
                this.blocks[ii][jj] = new double[this.blockLength * this.blockLength];
            }
        }
    }

    @Override
    public void zero() {
        throw new RuntimeException("Need to implement this");
    }

    @Override
    public double get(int row, int col) {
        int blockM = row / this.blockLength;
        int blockN = col / this.blockLength;
        int m = row % this.blockLength;
        int n = col % this.blockLength;
        int index = m * this.blockLength + n;
        return this.blocks[blockM][blockN][index];
    }

    @Override
    public void set(int row, int col, double val) {
        int blockM = row / this.blockLength;
        int blockN = col / this.blockLength;
        int m = row % this.blockLength;
        int n = col % this.blockLength;
        int index = m * this.blockLength + n;
        this.blocks[blockM][blockN][index] = val;
    }

    @Override
    public double unsafe_get(int row, int col) {
        return this.get(row, col);
    }

    @Override
    public void unsafe_set(int row, int col, double val) {
        this.set(row, col, val);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    @Override
    public void print(String format) {
    }

    @Override
    public <T extends Matrix> T copy() {
        throw new RuntimeException("Not supported");
    }

    public BlockD3Matrix64F createLike() {
        return new BlockD3Matrix64F(this.numRows, this.numCols);
    }

    public BlockD3Matrix64F create(int numRows, int numCols) {
        return new BlockD3Matrix64F(numRows, numCols);
    }

    @Override
    public void setTo(Matrix original) {
        throw new RuntimeException("Not supported yet");
    }

    @Override
    public MatrixType getType() {
        return MatrixType.UNSPECIFIED;
    }
}

