/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.pointinfo.AbstractPointInfoModule;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoAction;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoPreference;
import org.openstreetmap.josm.plugins.pointinfo.ReverseFinder;
import org.openstreetmap.josm.plugins.pointinfo.ReverseRecord;
import org.openstreetmap.josm.plugins.pointinfo.catastro.CatastroModule;
import org.openstreetmap.josm.plugins.pointinfo.ruian.RuianModule;
import org.openstreetmap.josm.spi.preferences.Config;

public class PointInfoPlugin
extends Plugin {
    private static final HashMap<String, AbstractPointInfoModule> modules = new HashMap();

    public PointInfoPlugin(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)MainApplication.getMenu().moreToolsMenu, (JosmAction)new PointInfoAction());
    }

    public PreferenceSetting getPreferenceSetting() {
        return new PointInfoPreference();
    }

    public static void registerModule(AbstractPointInfoModule module) {
        modules.put(module.getName(), module);
    }

    public static List<String> getModules() {
        return new ArrayList<String>(modules.keySet());
    }

    public static AbstractPointInfoModule getModule(LatLon pos) throws IOException {
        AbstractPointInfoModule module = null;
        if (Config.getPref().getBoolean("plugin.pointinfo.automode", true)) {
            ReverseRecord r = ReverseFinder.queryNominatim(pos);
            Iterator<AbstractPointInfoModule> i = modules.values().iterator();
            while (module == null && i.hasNext()) {
                AbstractPointInfoModule m = i.next();
                if (!r.matchAnyArea(m.getArea())) continue;
                module = m;
            }
        } else {
            module = modules.get(Config.getPref().get("plugin.pointinfo.module", "RUIAN"));
        }
        if (module == null) {
            module = modules.get("RUIAN");
        }
        return module;
    }

    static {
        PointInfoPlugin.registerModule(new RuianModule());
        PointInfoPlugin.registerModule(new CatastroModule());
    }
}

