/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImageLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ImportImageFileImporter
extends FileImporter {
    public ImportImageFileImporter() {
        super(new ExtensionFileFilter("tiff,tif,jpg,jpeg,bmp,png", "jpg", "Georeferenced image file [by ImportImage plugin] (*.jpg, *.jpeg, *.tif, *.tiff, *.png, *.bmp)"));
    }

    public boolean isBatchImporter() {
        return true;
    }

    public double getPriority() {
        return -3.0;
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) {
        if (null == files) {
            return;
        }
        for (File file : files) {
            ImageLayer layer;
            if (file.isDirectory()) continue;
            Logging.info((String)"ImportImageFileImporter: File chosen: {0}", (Object[])new Object[]{file});
            try {
                layer = new ImageLayer(file);
            }
            catch (ImageLayer.LayerCreationCanceledException e) {
                Logging.trace((Throwable)e);
                continue;
            }
            catch (Exception e) {
                Logging.error((String)"ImportImageFileImporter: Error while creating image layer: \n{0}", (Object[])new Object[]{e.getMessage()});
                Logging.error((Throwable)e);
                GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error while creating image layer: {0}", (Object[])new Object[]{e.getCause()})));
                continue;
            }
            MainApplication.getLayerManager().addLayer((Layer)layer);
        }
    }
}

