/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pbf.io;

import crosby.binary.BinarySerializer;
import crosby.binary.Osmformat;
import crosby.binary.StringTable;
import crosby.binary.file.BlockOutputStream;
import crosby.binary.file.FileBlock;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Logging;

public class PbfWriter
implements Closeable {
    private final PbfSerializer out;

    public PbfWriter(OutputStream out) {
        this.out = new PbfSerializer(new BlockOutputStream(out));
    }

    public void writeLayer(OsmDataLayer layer) {
        this.writeData(layer.getDataSet());
    }

    public void writeData(DataSet ds) {
        this.out.process(ds);
        this.out.complete();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    protected static class PbfSerializer
    extends BinarySerializer {
        protected boolean useDense = true;
        protected boolean headerWritten;
        private WayGroup ways;
        private NodeGroup nodes;
        private RelationGroup relations;
        private Processor processor = new Processor();

        public PbfSerializer(BlockOutputStream output) {
            super(output);
        }

        public void setUseDense(boolean useDense) {
            this.useDense = useDense;
        }

        private void switchTypes() {
            if (this.nodes != null) {
                this.groups.add(this.nodes);
                this.nodes = null;
            } else if (this.ways != null) {
                this.groups.add(this.ways);
                this.ways = null;
            } else if (this.relations != null) {
                this.groups.add(this.relations);
                this.relations = null;
            } else {
                Logging.debug((String)"No PBF data. Is this an empty file?");
            }
        }

        public void processBounds(DataSource entity) {
            Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
            Osmformat.HeaderBBox.Builder bbox = Osmformat.HeaderBBox.newBuilder();
            bbox.setLeft(this.mapRawDegrees(entity.bounds.getMinLon()));
            bbox.setBottom(this.mapRawDegrees(entity.bounds.getMinLat()));
            bbox.setRight(this.mapRawDegrees(entity.bounds.getMaxLon()));
            bbox.setTop(this.mapRawDegrees(entity.bounds.getMaxLat()));
            headerblock.setBbox(bbox);
            if (entity.origin != null) {
                headerblock.setSource(entity.origin);
            }
            this.finishHeader(headerblock);
        }

        public void writeEmptyHeaderIfNeeded() {
            if (this.headerWritten) {
                return;
            }
            Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
            this.finishHeader(headerblock);
        }

        public void finishHeader(Osmformat.HeaderBlock.Builder headerblock) {
            headerblock.setWritingprogram("JOSM");
            headerblock.addRequiredFeatures("OsmSchema-V0.6");
            if (this.useDense) {
                headerblock.addRequiredFeatures("DenseNodes");
            }
            Osmformat.HeaderBlock message = headerblock.build();
            try {
                this.output.write(FileBlock.newInstance("OSMHeader", message.toByteString(), null));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write OSM header.", e);
            }
            this.headerWritten = true;
        }

        public void process(DataSet ds) {
            this.processor.processSources(ds.getDataSources());
            Comparator<OsmPrimitive> cmp = Comparator.comparingLong(AbstractPrimitive::getUniqueId);
            ds.getNodes().stream().sorted(cmp).filter(AbstractPrimitive::isUsable).forEach(this.processor::processNode);
            ds.getWays().stream().sorted(cmp).filter(Way::isUsable).forEach(this.processor::processWay);
            ds.getRelations().stream().sorted(cmp).filter(AbstractPrimitive::isUsable).forEach(this.processor::processRelation);
        }

        public void complete() {
            try {
                this.switchTypes();
                this.processBatch();
                this.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to complete the PBF file.", e);
            }
        }

        public class Processor {
            public void processSources(Collection<DataSource> sources) {
                PbfSerializer.this.switchTypes();
                if (!sources.isEmpty()) {
                    PbfSerializer.this.processBounds(sources.iterator().next());
                }
            }

            public void checkLimit() {
                PbfSerializer.this.total_entities++;
                if (++PbfSerializer.this.batch_size < PbfSerializer.this.batch_limit) {
                    return;
                }
                PbfSerializer.this.switchTypes();
                PbfSerializer.this.processBatch();
            }

            public void processNode(Node node) {
                if (PbfSerializer.this.nodes == null) {
                    PbfSerializer.this.writeEmptyHeaderIfNeeded();
                    PbfSerializer.this.switchTypes();
                    PbfSerializer.this.nodes = new NodeGroup();
                }
                if (node.isLatLonKnown()) {
                    PbfSerializer.this.nodes.add(node);
                    this.checkLimit();
                }
            }

            public void processWay(Way way) {
                if (PbfSerializer.this.ways == null) {
                    PbfSerializer.this.writeEmptyHeaderIfNeeded();
                    PbfSerializer.this.switchTypes();
                    PbfSerializer.this.ways = new WayGroup();
                }
                PbfSerializer.this.ways.add(way);
                this.checkLimit();
            }

            public void processRelation(Relation relation) {
                if (PbfSerializer.this.relations == null) {
                    PbfSerializer.this.writeEmptyHeaderIfNeeded();
                    PbfSerializer.this.switchTypes();
                    PbfSerializer.this.relations = new RelationGroup();
                }
                PbfSerializer.this.relations.add(relation);
                this.checkLimit();
            }
        }

        private class RelationGroup
        extends Prim<Relation>
        implements BinarySerializer.PrimGroupWriterInterface {
            private RelationGroup() {
            }

            @Override
            public void addStringsToStringtable() {
                StringTable stable = PbfSerializer.this.getStringTable();
                super.addStringsToStringtable();
                for (Relation i : this.contents) {
                    for (RelationMember j : i.getMembers()) {
                        stable.incr(j.getRole());
                    }
                }
            }

            @Override
            public Osmformat.PrimitiveGroup serialize() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                StringTable stable = PbfSerializer.this.getStringTable();
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                for (Relation i : this.contents) {
                    Osmformat.Relation.Builder bi = Osmformat.Relation.newBuilder();
                    bi.setId(i.getUniqueId());
                    RelationMember[] arr = new RelationMember[i.getMembers().size()];
                    i.getMembers().toArray(arr);
                    long lastid = 0L;
                    for (RelationMember j : i.getMembers()) {
                        long id = j.getMember().getUniqueId();
                        bi.addMemids(id - lastid);
                        lastid = id;
                        if (j.getType() == OsmPrimitiveType.NODE) {
                            bi.addTypes(Osmformat.Relation.MemberType.NODE);
                        } else if (j.getType() == OsmPrimitiveType.WAY) {
                            bi.addTypes(Osmformat.Relation.MemberType.WAY);
                        } else if (j.getType() == OsmPrimitiveType.RELATION) {
                            bi.addTypes(Osmformat.Relation.MemberType.RELATION);
                        } else assert (false);
                        bi.addRolesSid(stable.getIndex(j.getRole()));
                    }
                    for (Map.Entry t : i.getKeys().entrySet()) {
                        bi.addKeys(stable.getIndex((String)t.getKey()));
                        bi.addVals(stable.getIndex((String)t.getValue()));
                    }
                    if (!PbfSerializer.this.omit_metadata) {
                        bi.setInfo(this.serializeMetadata((OsmPrimitive)i));
                    }
                    builder.addRelations(bi);
                }
                return builder.build();
            }
        }

        private class WayGroup
        extends Prim<Way>
        implements BinarySerializer.PrimGroupWriterInterface {
            private WayGroup() {
            }

            @Override
            public Osmformat.PrimitiveGroup serialize() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                StringTable stable = PbfSerializer.this.getStringTable();
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                for (Way i : this.contents) {
                    Osmformat.Way.Builder bi = Osmformat.Way.newBuilder();
                    bi.setId(i.getUniqueId());
                    long lastid = 0L;
                    for (Node j : i.getNodes()) {
                        long id = j.getUniqueId();
                        bi.addRefs(id - lastid);
                        lastid = id;
                    }
                    for (Map.Entry t : i.getKeys().entrySet()) {
                        bi.addKeys(stable.getIndex((String)t.getKey()));
                        bi.addVals(stable.getIndex((String)t.getValue()));
                    }
                    if (!PbfSerializer.this.omit_metadata) {
                        bi.setInfo(this.serializeMetadata((OsmPrimitive)i));
                    }
                    builder.addWays(bi);
                }
                return builder.build();
            }
        }

        private class NodeGroup
        extends Prim<Node>
        implements BinarySerializer.PrimGroupWriterInterface {
            private NodeGroup() {
            }

            @Override
            public Osmformat.PrimitiveGroup serialize() {
                if (PbfSerializer.this.useDense) {
                    return this.serializeDense();
                }
                return this.serializeNonDense();
            }

            public Osmformat.PrimitiveGroup serializeDense() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                StringTable stable = PbfSerializer.this.getStringTable();
                long lastlat = 0L;
                long lastlon = 0L;
                long lastid = 0L;
                Osmformat.DenseNodes.Builder bi = Osmformat.DenseNodes.newBuilder();
                boolean doesBlockHaveTags = false;
                for (Node i : this.contents) {
                    doesBlockHaveTags = doesBlockHaveTags || i.hasKeys();
                }
                if (!PbfSerializer.this.omit_metadata) {
                    Osmformat.DenseInfo.Builder bdi = Osmformat.DenseInfo.newBuilder();
                    this.serializeMetadataDense(bdi, this.contents);
                    bi.setDenseinfo(bdi);
                }
                for (Node i : this.contents) {
                    long id = i.getUniqueId();
                    bi.addId(id - lastid);
                    lastid = id;
                    if (i.isLatLonKnown()) {
                        int lat = PbfSerializer.this.mapDegrees(i.lat());
                        int lon = PbfSerializer.this.mapDegrees(i.lon());
                        bi.addLon((long)lon - lastlon);
                        lastlon = lon;
                        bi.addLat((long)lat - lastlat);
                        lastlat = lat;
                    }
                    if (!doesBlockHaveTags) continue;
                    for (Map.Entry t : i.getKeys().entrySet()) {
                        bi.addKeysVals(stable.getIndex((String)t.getKey()));
                        bi.addKeysVals(stable.getIndex((String)t.getValue()));
                    }
                    bi.addKeysVals(0);
                }
                builder.setDense(bi);
                return builder.build();
            }

            public Osmformat.PrimitiveGroup serializeNonDense() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                StringTable stable = PbfSerializer.this.getStringTable();
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                for (Node i : this.contents) {
                    long id = i.getUniqueId();
                    int lat = PbfSerializer.this.mapDegrees(i.lat());
                    int lon = PbfSerializer.this.mapDegrees(i.lon());
                    Osmformat.Node.Builder bi = Osmformat.Node.newBuilder();
                    bi.setId(id);
                    bi.setLon(lon);
                    bi.setLat(lat);
                    for (Map.Entry t : i.getKeys().entrySet()) {
                        bi.addKeys(stable.getIndex((String)t.getKey()));
                        bi.addVals(stable.getIndex((String)t.getValue()));
                    }
                    if (!PbfSerializer.this.omit_metadata) {
                        bi.setInfo(this.serializeMetadata((OsmPrimitive)i));
                    }
                    builder.addNodes(bi);
                }
                return builder.build();
            }
        }

        private abstract class Prim<T extends OsmPrimitive> {
            ArrayList<T> contents = new ArrayList();

            private Prim() {
            }

            public void add(T item) {
                this.contents.add(item);
            }

            public void addStringsToStringtable() {
                StringTable stable = PbfSerializer.this.getStringTable();
                for (OsmPrimitive i : this.contents) {
                    for (Map.Entry tag : i.getKeys().entrySet()) {
                        stable.incr((String)tag.getKey());
                        stable.incr((String)tag.getValue());
                    }
                    if (PbfSerializer.this.omit_metadata) continue;
                    stable.incr(this.getUserId(i));
                }
            }

            private String getUserId(OsmPrimitive osm) {
                String userId;
                String string = userId = osm.getUser() != null ? osm.getUser().getName() : null;
                if (userId == null) {
                    userId = "";
                }
                return userId;
            }

            public void serializeMetadataDense(Osmformat.DenseInfo.Builder b, List<? extends OsmPrimitive> entities) {
                if (PbfSerializer.this.omit_metadata) {
                    return;
                }
                long lasttimestamp = 0L;
                long lastchangeset = 0L;
                int lastuserSid = 0;
                int lastuid = 0;
                StringTable stable = PbfSerializer.this.getStringTable();
                for (OsmPrimitive osmPrimitive : entities) {
                    int uid = osmPrimitive.getUser() == null ? -1 : (int)osmPrimitive.getUser().getId();
                    int userSid = stable.getIndex(this.getUserId(osmPrimitive));
                    int timestamp = (int)(osmPrimitive.getInstant().toEpochMilli() / (long)PbfSerializer.this.date_granularity);
                    int version = osmPrimitive.getVersion();
                    long changeset = osmPrimitive.getChangesetId();
                    b.addVersion(version);
                    b.addTimestamp((long)timestamp - lasttimestamp);
                    lasttimestamp = timestamp;
                    b.addChangeset(changeset - lastchangeset);
                    lastchangeset = changeset;
                    b.addUid(uid - lastuid);
                    lastuid = uid;
                    b.addUserSid(userSid - lastuserSid);
                    lastuserSid = userSid;
                }
            }

            public Osmformat.Info.Builder serializeMetadata(OsmPrimitive e) {
                StringTable stable = PbfSerializer.this.getStringTable();
                Osmformat.Info.Builder b = Osmformat.Info.newBuilder();
                if (!PbfSerializer.this.omit_metadata) {
                    if (e.getUser() != null) {
                        b.setUid((int)e.getUser().getId());
                        b.setUserSid(stable.getIndex(e.getUser().getName()));
                    }
                    b.setTimestamp((int)(e.getInstant().toEpochMilli() / (long)PbfSerializer.this.date_granularity));
                    b.setVersion(e.getVersion());
                    b.setChangeset(e.getChangesetId());
                }
                return b;
            }
        }
    }
}

