/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class IdenticalTurnRestrictionLegsError
extends Issue {
    private OsmPrimitive leg;

    public IdenticalTurnRestrictionLegsError(IssuesModel parent, OsmPrimitive leg) {
        super(parent, Severity.ERROR);
        this.actions.add(new DeleteFromAction());
        this.actions.add(new DeleteToAction());
        this.actions.add(new FixInEditorAction());
        this.leg = leg;
    }

    @Override
    public String getText() {
        return I18n.tr((String)"This turn restriction uses the way <span class=\"object-name\">{0}</span> with role <tt>from</tt> <strong>and</strong> with role <tt>to</tt>. In a turn restriction, the way with role <tt>from</tt> should be different from the way with role <tt>to</tt>, though.", (Object[])new Object[]{this.leg.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
    }

    class FixInEditorAction
    extends AbstractAction {
        FixInEditorAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Go to Basic Editor and manually choose members with roles ''from'' and ''to''", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdenticalTurnRestrictionLegsError.this.getIssuesModel().getNavigationControler().gotoBasicEditor();
        }
    }

    class DeleteToAction
    extends AbstractAction {
        DeleteToAction() {
            this.putValue("Name", I18n.tr((String)"Delete ''to''", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Removes the member with role ''to''", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdenticalTurnRestrictionLegsError.this.getIssuesModel().getEditorModel().getRelationMemberEditorModel().setToPrimitive(null);
        }
    }

    class DeleteFromAction
    extends AbstractAction {
        DeleteFromAction() {
            this.putValue("Name", I18n.tr((String)"Delete ''from''", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Removes the member with role ''from''", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdenticalTurnRestrictionLegsError.this.getIssuesModel().getEditorModel().getRelationMemberEditorModel().setFromPrimitive(null);
        }
    }
}

